function showNotice(errors, type){

    Swal.fire({
        icon: type,

        html: '<div style="max-width: 200px; word-wrap: break-word;">'+errors+'</div>',
        position: 'top-end',
        toast: true,
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: true,
    });
}

Pusher.logToConsole = true;
var csrfToken =$('meta[name="csrf-token"]').attr('content');

// Gloabl Chatify variables from PHP to JS

Pusher.logToConsole = chatify.pusher.debug;
const pusher = new Pusher(chatify.pusher.key, {
    encrypted: chatify.pusher.options.encrypted,
    cluster: chatify.pusher.options.cluster,
    wsHost: chatify.pusher.options.host,
    wsPort: chatify.pusher.options.port,
    wssPort: chatify.pusher.options.port,
    forceTLS: chatify.pusher.options.useTLS,
    enableClientMessages: true,
    authEndpoint: "{{route('merchant.merchantpusher.auth')}}",
    auth: {
        headers: {
            "X-CSRF-TOKEN": csrfToken,
        },
    },
});


pusher.connection.bind('connected', function(){
    console.log('Pusher is connected to server');
});

// -------------------------------------
// presence channel [User Active Status]
var activeStatusChannel = pusher.subscribe("presence-activeStatus");

// Joined
activeStatusChannel.bind("pusher:member_added", function (member) {
    console.log(member.id);
});

// Leaved
activeStatusChannel.bind("pusher:member_removed", function (member) {
    console.log(member.id);
});
var noticeChannel = pusher.subscribe('notify{{auth()->user()->access_key}}');
noticeChannel.bind('trade-request',function(data){
    showNotice('One Trade Request','info');
    var noticeT = parseInt($(".noticebar").text());
    // var totalNotice = partnoticeT+1;
    $(".noticebar").text(noticeT+1);
    console.log(data);
    console.log("we recieve inite");
})

