---
title: XlmTx
parent: Model
layout: page
---

# XlmTx

## Model getters

Method name | Return type | Description | Notes
------------ | ------------- | ------------- | -------------
**getId()** | **string** | A unique identifier for this transaction. <br>Example: `749e4f8933221b9942ef38a02856803f379789ec8d971f1f60535db70135673e` | [optional]
**getPagingToken()** | **string** | A cursor value for use in pagination. <br>Example: `438086668288` | [optional]
**getSuccessful()** | **bool** | Indicates if this transaction was successful or not. <br>Example: `true` | [optional]
**getHash()** | **string** | A hex-encoded SHA-256 hash of this transaction’s XDR-encoded form. <br>Example: `749e4f8933221b9942ef38a02856803f379789ec8d971f1f60535db70135673e` | [optional]
**getLedger()** | **float** | The sequence number of the ledger that this transaction was included in. <br>Example: `102` | [optional]
**getCreatedAt()** | **string** | The date this transaction was created. <br>Example: `2019-10-30T09:34:07Z` | [optional]
**getSourceAccount()** | **string** | The account that originates the transaction. <br>Example: `GBRPYHIL2CI3FNQ4BXLFMNDLFJUNPU2HY3ZMFSHONUCEOASW7QC7OX2H` | [optional]
**getSourceAccountSequence()** | **string** | The source account’s sequence number that this transaction consumed. <br>Example: `1` | [optional]
**getFeePaid()** | **float** | The fee (in stroops) paid by the source account to apply this transaction to the ledger. <br>Example: `1000` | [optional]
**getFeeCharged()** | **float** |  <br>Example: `1000` | [optional]
**getMaxFee()** | **float** | The maximum fee (in stroops) that the source account was willing to pay. <br>Example: `1000` | [optional]
**getOperationCount()** | **float** | The number of operations contained within this transaction. <br>Example: `10` | [optional]
**getEnvelopeXdr()** | **string** | A base64 encoded string of the raw TransactionEnvelope XDR struct for this transaction. <br>Example: `AAAAAGL8HQvQkbK2HA3WVjRrKmjX00fG8sLI7m0ERwJW/AX3AAAD6AAAAAAAAAABAAAAAAAAAAAAAAAKAAAAAAAAAAAAAAAAEH3Rayw4M0iCLoEe96rPFNGYim8AVHJU0z4ebYZW4JwBY0V4XYoAAAAAAAAAAAAAAAAAAN2+SherpNcNX0imC680fIBdpQfgBwIuqFOgmlobpwLJAAAAF0h26AAAAAAAAAAAAAAAAAAAlRt2go9sp7E1a5ZWvr7vin4UPrFQThpQax1lOFm33AAAABdIdugAAAAAAAAAAAAAAAAAmv+knlR6JR2VqWeU0k/4FgvZ/tSV5DEY4gu0iOTKgpUAAAAXSHboAAAAAAAAAAAAAAAAANpaWLojuOtfC0cmMh+DvQTfPDrkfXhblQTdFXrGYc0bAAAAF0h26AAAAAABAAAAAACVG3aCj2ynsTVrlla+vu+KfhQ+sVBOGlBrHWU4WbfcAAAABgAAAAFURVNUAAAAANpaWLojuOtfC0cmMh+DvQTfPDrkfXhblQTdFXrGYc0bf/////////8AAAABAAAAAJr/pJ5UeiUdlalnlNJP+BYL2f7UleQxGOILtIjkyoKVAAAABgAAAAFURVNUAAAAANpaWLojuOtfC0cmMh+DvQTfPDrkfXhblQTdFXrGYc0bf/////////8AAAABAAAAANpaWLojuOtfC0cmMh+DvQTfPDrkfXhblQTdFXrGYc0bAAAAAQAAAAAAlRt2go9sp7E1a5ZWvr7vin4UPrFQThpQax1lOFm33AAAAAFURVNUAAAAANpaWLojuOtfC0cmMh+DvQTfPDrkfXhblQTdFXrGYc0bAAAJGE5yoAAAAAABAAAAANpaWLojuOtfC0cmMh+DvQTfPDrkfXhblQTdFXrGYc0bAAAAAQAAAACa/6SeVHolHZWpZ5TST/gWC9n+1JXkMRjiC7SI5MqClQAAAAFURVNUAAAAANpaWLojuOtfC0cmMh+DvQTfPDrkfXhblQTdFXrGYc0bAAAJGE5yoAAAAAAAAAAAAAAAAABKBB+2UBMP/abwcm/M1TXO+/JQWhPwkalgqizKmXyRIQx9cN3sY5YAAAAAAAAAAARW/AX3AAAAQDX5vrTLWyUxzrvpeEghwlfZYjb8PhnV+vjXAQE+iCNotx2S0qDtnNppNy9p0qlsXtKKyZqn036kHMFGQ7RxBQ3GYc0bAAAAQOquRvJeUiQ8uDcNGUnIxXT0xaHe91JZHCVjPEm6j9Biii954p9o7Muer9B9ipn6O4Y+4oiF9NbUxyeqh1VJnQw4WbfcAAAAQG/GEctb+uefyEvdeP8V61fCvvdGCW7KoH7iLXxtvanGk9CyydtRGEIxu66hPdUKKbXpXPEKWvnAAp5V+XQqjQnkyoKVAAAAQNTyKwB94kyBjjczpFwMFVtbhHtugo+DYeQKN13jQUjWQDSgistLE+TDrxlxW0qiIhl/GkOdVLMtG6YhfZeVOQU=` | [optional]
**getResultXdr()** | **string** | A base64 encoded string of the raw TransactionResult XDR struct for this transaction. <br>Example: `AAAAAAAAA+gAAAAAAAAACgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGAAAAAAAAAAAAAAAGAAAAAAAAAAAAAAABAAAAAAAAAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAA=` | [optional]
**getResultMetaXdr()** | **string** | A base64 encoded string of the raw TransactionMeta XDR struct for this transaction <br>Example: `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` | [optional]
**getFeeMetaXdr()** | **string** | A base64 encoded string of the raw LedgerEntryChanges XDR struct produced by taking fees for this transaction. <br>Example: `AAAAAgAAAAMAAAABAAAAAAAAAABi/B0L0JGythwN1lY0aypo19NHxvLCyO5tBEcCVvwF9w3gtrOnZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAEAAABmAAAAAAAAAABi/B0L0JGythwN1lY0aypo19NHxvLCyO5tBEcCVvwF9w3gtrOnY/wYAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAA==` | [optional]
**getMemo()** | **string** | The optional memo attached to a transaction. Usually used as an account distiguisher. <br>Example: `12345` | [optional]
**getMemoType()** | **string** | The type of memo. <br>Example: `MEMO_TEXT` | [optional]
**getSignatures()** | **string[]** | An array of signatures used to sign this transaction. <br>Example: `["Nfm+tMtbJTHOu+l4SCHCV9liNvw+GdX6+NcBAT6II2i3HZLSoO2c2mk3L2nSqWxe0orJmqfTfqQcwUZDtHEFDQ==","6q5G8l5SJDy4Nw0ZScjFdPTFod73UlkcJWM8SbqP0GKKL3nin2jsy56v0H2Kmfo7hj7iiIX01tTHJ6qHVUmdDA==","b8YRy1v655/IS914/xXrV8K+90YJbsqgfuItfG29qcaT0LLJ21EYQjG7rqE91Qoptelc8Qpa+cACnlX5dCqNCQ==","1PIrAH3iTIGONzOkXAwVW1uEe26Cj4Nh5Ao3XeNBSNZANKCKy0sT5MOvGXFbSqIiGX8aQ51Usy0bpiF9l5U5BQ=="]` | [optional]

