<?php

/**
 * Implementation of CustodialManagedWallets API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for CustodialManagedWallets
 */
class CustodialManagedWalletsApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Custodial managed wallets";

    /**
     * Create managed address
     *
     * @param \Tatum\Model\CustodialCreateWalletRequest|null $custodial_create_wallet_request 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\CustodialManagedAddress
     */
    public function custodialCreateWallet($custodial_create_wallet_request = null) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/custodial/wallet";
        /** @var \Tatum\Model\CustodialManagedAddress $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $custodial_create_wallet_request
            ), 
            "\Tatum\Model\CustodialManagedAddress"
        );
            
        return $result;
    }
    
    /**
     * Delete managed address
     *
     * @param string $id WalletID of the managed address
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function custodialDeleteWallet($id) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/custodial/wallet/{id}";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "DELETE", S::parse($rPath, ["id" => $id]), $rPath, [], $rHeaders, []
            )
        );
    }
    
    /**
     * Get managed address
     *
     * @param string $id WalletID of the managed address
     * @param bool|false $export If set to \&quot;true\&quot;, returns the private key in the response; if not set, defaults to \&quot;false\&quot; (the private key is not included in the response)
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\CustodialManagedAddress[]
     */
    public function custodialGetWallet($id, $export = false) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/custodial/wallet/{id}";
        /** @var \Tatum\Model\CustodialManagedAddress[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["id" => $id]), $rPath, [
                    "export" => S::toQueryValue($export),
                ], $rHeaders, []
            ), 
            "\Tatum\Model\CustodialManagedAddress[]"
        );
            
        return $result;
    }
    
    /**
     * Get managed addresses
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\CustodialManagedAddress[]
     */
    public function custodialGetWallets() {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/custodial/wallet";
        /** @var \Tatum\Model\CustodialManagedAddress[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", $rPath, $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\CustodialManagedAddress[]"
        );
            
        return $result;
    }
    
    /**
     * Sign and transfer using managed address
     *
     * @param \Tatum\Model\TransferManagedAddress|null $transfer_managed_address 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionHash
     */
    public function custodialTransferManagedAddress($transfer_managed_address = null) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/custodial/transaction";
        /** @var \Tatum\Model\TransactionHash $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_managed_address
            ), 
            "\Tatum\Model\TransactionHash"
        );
            
        return $result;
    }
    
}
