<?php

/**
 * Implementation of Harmony API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for Harmony
 */
class HarmonyApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Harmony";

    /**
     * Invoke a method in a smart contract on Harmony
     *
     * @param \Tatum\Model\CallOneReadSmartContractMethod $call_one_read_smart_contract_method 
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\CallSmartContractMethod200Response
     */
    public function callOneReadSmartContractMethod($call_one_read_smart_contract_method, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/one/smartcontract";
        /** @var \Tatum\Model\CallSmartContractMethod200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $call_one_read_smart_contract_method
            ), 
            "\Tatum\Model\CallSmartContractMethod200Response"
        );
            
        return $result;
    }
    
    /**
     * Invoke a method in a smart contract on Harmony
     *
     * @param \Tatum\Model\CallOneSmartContractMethod $call_one_smart_contract_method 
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\CallSmartContractMethod200Response
     */
    public function callOneSmartContractMethod($call_one_smart_contract_method, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/one/smartcontract";
        /** @var \Tatum\Model\CallSmartContractMethod200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $call_one_smart_contract_method
            ), 
            "\Tatum\Model\CallSmartContractMethod200Response"
        );
            
        return $result;
    }
    
    /**
     * Invoke a method in a smart contract on Harmony
     *
     * @param \Tatum\Model\CallOneSmartContractMethodKMS $call_one_smart_contract_method_kms 
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\CallSmartContractMethod200Response
     */
    public function callOneSmartContractMethodKMS($call_one_smart_contract_method_kms, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/one/smartcontract";
        /** @var \Tatum\Model\CallSmartContractMethod200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $call_one_smart_contract_method_kms
            ), 
            "\Tatum\Model\CallSmartContractMethod200Response"
        );
            
        return $result;
    }
    
    /**
     * Broadcast signed ONE transaction
     *
     * @param \Tatum\Model\BroadcastKMS $broadcast_kms 
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionHash
     */
    public function oneBroadcast($broadcast_kms, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/one/broadcast";
        /** @var \Tatum\Model\TransactionHash $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $broadcast_kms
            ), 
            "\Tatum\Model\TransactionHash"
        );
            
        return $result;
    }
    
    /**
     * Transform HEX address to Bech32 ONE address format
     *
     * @param string $address Address in HEX (ETH compatible) format.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GeneratedAddressOne
     */
    public function oneFormatAddress($address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/one/address/format/{address}";
        /** @var \Tatum\Model\GeneratedAddressOne $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["address" => $address]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\GeneratedAddressOne"
        );
            
        return $result;
    }
    
    /**
     * Generate ONE account address from Extended public key
     *
     * @param string $xpub Extended public key of wallet.
     * @param float $index Derivation index of desired address to be generated.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GeneratedAddressOne
     */
    public function oneGenerateAddress($xpub, $index) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/one/address/{xpub}/{index}";
        /** @var \Tatum\Model\GeneratedAddressOne $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["xpub" => $xpub, "index" => $index]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\GeneratedAddressOne"
        );
            
        return $result;
    }
    
    /**
     * Generate ONE private key
     *
     * @param \Tatum\Model\PrivKeyRequest $priv_key_request 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\PrivKey
     */
    public function oneGenerateAddressPrivateKey($priv_key_request) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/one/wallet/priv";
        /** @var \Tatum\Model\PrivKey $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $priv_key_request
            ), 
            "\Tatum\Model\PrivKey"
        );
            
        return $result;
    }
    
    /**
     * Generate ONE wallet
     *
     * @param string|null $mnemonic Mnemonic to use for generation of extended public and private keys.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Wallet
     */
    public function oneGenerateWallet($mnemonic = null) {
        if (isset($mnemonic) && strlen($mnemonic) > 500) {
            throw new IAE('Invalid length for "$mnemonic" when calling HarmonyApi.oneGenerateWallet, must be smaller than or equal to 500');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/one/wallet";
        /** @var \Tatum\Model\Wallet $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", $rPath, $rPath, [
                    "mnemonic" => isset($mnemonic) ? S::toQueryValue($mnemonic) : null,
                ], $rHeaders, []
            ), 
            "\Tatum\Model\Wallet"
        );
            
        return $result;
    }
    
    /**
     * Get ONE Account balance
     *
     * @param string $address Account address you want to get balance of
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\OneBalance
     */
    public function oneGetBalance($address, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/one/account/balance/{address}";
        /** @var \Tatum\Model\OneBalance $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["address" => $address]), $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, []
            ), 
            "\Tatum\Model\OneBalance"
        );
            
        return $result;
    }
    
    /**
     * Get ONE block by hash
     *
     * @param string $hash Block hash or block number
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\EthBlock
     */
    public function oneGetBlock($hash, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/one/block/{hash}";
        /** @var \Tatum\Model\EthBlock $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["hash" => $hash]), $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, []
            ), 
            "\Tatum\Model\EthBlock"
        );
            
        return $result;
    }
    
    /**
     * Get current block number
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\OneBlockCurrent[]
     */
    public function oneGetCurrentBlock() {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/one/block/current";
        /** @var \Tatum\Model\OneBlockCurrent[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", $rPath, $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\OneBlockCurrent[]"
        );
            
        return $result;
    }
    
    /**
     * Get ONE Transaction
     *
     * @param string $hash Transaction hash
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\OneTx
     */
    public function oneGetTransaction($hash, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/one/transaction/{hash}";
        /** @var \Tatum\Model\OneTx $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["hash" => $hash]), $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, []
            ), 
            "\Tatum\Model\OneTx"
        );
            
        return $result;
    }
    
    /**
     * Get count of outgoing ONE transactions
     *
     * @param string $address address
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return float
     */
    public function oneGetTransactionCount($address, $shard_id = 0) {
        if (strlen($address) > 42) {
            throw new IAE('Invalid length for "$address" when calling HarmonyApi.oneGetTransactionCount, must be smaller than or equal to 42');
        }

        if (strlen($address) < 42) {
            throw new IAE('Invalid length for "$address" when calling HarmonyApi.oneGetTransactionCount, must be bigger than or equal to 42');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/one/transaction/count/{address}";
        /** @var float $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["address" => $address]), $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, []
            ), 
            "float"
        );
            
        return $result;
    }
    
    /**
     * Send ONE from account to account
     *
     * @param \Tatum\Model\TransferOneBlockchain $transfer_one_blockchain 
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferOneBlockchain($transfer_one_blockchain, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/one/transaction";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $transfer_one_blockchain
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Send ONE from account to account
     *
     * @param \Tatum\Model\TransferOneBlockchainKMS $transfer_one_blockchain_kms 
     * @param float|0 $shard_id Shard to read data from
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferOneBlockchainKMS($transfer_one_blockchain_kms, $shard_id = 0) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/one/transaction";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [
                    "shardID" => S::toQueryValue($shard_id),
                ], $rHeaders, [], $transfer_one_blockchain_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
}
