<?php

/**
 * Implementation of NodeRPC API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for NodeRPC
 */
class NodeRPCApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Node RPC";

    /**
     * Connect to the blockchain node through an RPC driver
     *
     * @param string $chain Blockchain to communicate with.
     * @param object $body 
     * @param string|null $x_api_key Tatum X-API-Key used for authorization. You can omit this path parameter and either use the X-Api-Key header, or the API key tied to your IP address without any header.
     * @param string|null $node_type Type of the node to access for Algorand.
     * @param string|'ethereum-sepolia' $testnet_type Type of Ethereum testnet. Defaults to ethereum-sepolia.
     * @param string|'avax-c' $chain_type Type of Avalanche network. Defaults to Avalanche C-Chain.
     * @param string|null $rpc_path Optional path of rpc call for non EVM nodes, e.g. Algorand or Stellar.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return object
     */
    public function nodeJsonPostRpcDriver($chain, $body, $x_api_key = null, $node_type = null, $testnet_type = 'ethereum-sepolia', $chain_type = 'avax-c', $rpc_path = null) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/node/{chain}/{xApiKey}/{rpcPath}";
        /** @var object $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", S::parse($rPath, ["xApiKey" => $x_api_key, "chain" => $chain, "rpcPath" => $rpc_path]), $rPath, [
                    "nodeType" => isset($node_type) ? S::toQueryValue($node_type) : null,
                    "testnetType" => S::toQueryValue($testnet_type),
                    "chainType" => S::toQueryValue($chain_type),
                ], $rHeaders, [], $body
            ), 
            "object"
        );
            
        return $result;
    }
    
    /**
     * Connect to the blockchain node through an RPC driver
     *
     * @param string $chain Blockchain to communicate with.
     * @param string|null $x_api_key Tatum X-API-Key used for authorization. You can omit this path parameter and either use the X-Api-Key header, or the API key tied to your IP address without any header.
     * @param string|null $node_type Type of the node to access for Algorand.
     * @param string|null $rpc_path Optional path of rpc call for non EVM nodes, e.g. Algorand or Stellar.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return object
     */
    public function nodeJsonRpcGetDriver($chain, $x_api_key = null, $node_type = null, $rpc_path = null) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/blockchain/node/{chain}/{xApiKey}/{rpcPath}";
        /** @var object $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["xApiKey" => $x_api_key, "chain" => $chain, "rpcPath" => $rpc_path]), $rPath, [
                    "nodeType" => isset($node_type) ? S::toQueryValue($node_type) : null,
                ], $rHeaders, []
            ), 
            "object"
        );
            
        return $result;
    }
    
    /**
     * Connect to the blockchain node through an RPC driver
     *
     * @param string $chain Blockchain to communicate with.
     * @param object $body 
     * @param string|null $x_api_key Tatum X-API-Key used for authorization. You can omit this path parameter and either use the X-Api-Key header, or the API key tied to your IP address without any header.
     * @param string|null $node_type Type of the node to access for Algorand.
     * @param string|null $rpc_path Optional path of rpc call for non EVM nodes, e.g. Algorand or Stellar.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return object
     */
    public function nodeJsonRpcPutDriver($chain, $body, $x_api_key = null, $node_type = null, $rpc_path = null) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/node/{chain}/{xApiKey}/{rpcPath}";
        /** @var object $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", S::parse($rPath, ["xApiKey" => $x_api_key, "chain" => $chain, "rpcPath" => $rpc_path]), $rPath, [
                    "nodeType" => isset($node_type) ? S::toQueryValue($node_type) : null,
                ], $rHeaders, [], $body
            ), 
            "object"
        );
            
        return $result;
    }
    
}
