<?php

/**
 * Implementation of VirtualCurrency API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for VirtualCurrency
 */
class VirtualCurrencyApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Virtual Currency";

    /**
     * Create new virtual currency
     *
     * @param \Tatum\Model\VirtualCurrency $virtual_currency 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Account
     */
    public function createCurrency($virtual_currency) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/ledger/virtualCurrency";
        /** @var \Tatum\Model\Account $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $virtual_currency
            ), 
            "\Tatum\Model\Account"
        );
            
        return $result;
    }
    
    /**
     * Get virtual currency
     *
     * @param string $name 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\VC
     */
    public function getCurrency($name) {
        if (strlen($name) > 100) {
            throw new IAE('Invalid length for "$name" when calling VirtualCurrencyApi.getCurrency, must be smaller than or equal to 100');
        }

        if (strlen($name) < 3) {
            throw new IAE('Invalid length for "$name" when calling VirtualCurrencyApi.getCurrency, must be bigger than or equal to 3');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/ledger/virtualCurrency/{name}";
        /** @var \Tatum\Model\VC $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["name" => $name]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\VC"
        );
            
        return $result;
    }
    
    /**
     * Create new supply of virtual currency
     *
     * @param \Tatum\Model\VirtualCurrencyOperation $virtual_currency_operation 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionResult
     */
    public function mintCurrency($virtual_currency_operation) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/ledger/virtualCurrency/mint";
        /** @var \Tatum\Model\TransactionResult $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $virtual_currency_operation
            ), 
            "\Tatum\Model\TransactionResult"
        );
            
        return $result;
    }
    
    /**
     * Destroy supply of virtual currency
     *
     * @param \Tatum\Model\VirtualCurrencyOperation $virtual_currency_operation 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionResult
     */
    public function revokeCurrency($virtual_currency_operation) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/ledger/virtualCurrency/revoke";
        /** @var \Tatum\Model\TransactionResult $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $virtual_currency_operation
            ), 
            "\Tatum\Model\TransactionResult"
        );
            
        return $result;
    }
    
    /**
     * Update virtual currency
     *
     * @param \Tatum\Model\VirtualCurrencyUpdate $virtual_currency_update 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function updateCurrency($virtual_currency_update) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/ledger/virtualCurrency";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", $rPath, $rPath, [], $rHeaders, [], $virtual_currency_update
            )
        );
    }
    
}
