<?php

/**
 * Implementation of Withdrawal API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for Withdrawal
 */
class WithdrawalApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Withdrawal";

    /**
     * Broadcast signed transaction and complete withdrawal
     *
     * @param \Tatum\Model\BroadcastWithdrawal $broadcast_withdrawal 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\BroadcastResponse
     */
    public function broadcastBlockchainTransaction($broadcast_withdrawal) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/withdrawal/broadcast";
        /** @var \Tatum\Model\BroadcastResponse $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $broadcast_withdrawal
            ), 
            "\Tatum\Model\BroadcastResponse"
        );
            
        return $result;
    }
    
    /**
     * Cancel withdrawal
     *
     * @param string $id ID of created withdrawal
     * @param bool|true $revert Defines whether fee should be reverted to account balance as well as amount. Defaults to true. Revert true would be typically used when withdrawal was not broadcast to blockchain. False is used usually for Ethereum based currencies when gas was consumed but transaction was reverted.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function cancelInProgressWithdrawal($id, $revert = true) {
        if (strlen($id) > 24) {
            throw new IAE('Invalid length for "$id" when calling WithdrawalApi.cancelInProgressWithdrawal, must be smaller than or equal to 24');
        }

        if (strlen($id) < 24) {
            throw new IAE('Invalid length for "$id" when calling WithdrawalApi.cancelInProgressWithdrawal, must be bigger than or equal to 24');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/offchain/withdrawal/{id}";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "DELETE", S::parse($rPath, ["id" => $id]), $rPath, [
                    "revert" => S::toQueryValue($revert),
                ], $rHeaders, []
            )
        );
    }
    
    /**
     * Complete withdrawal
     *
     * @param string $id ID of created withdrawal
     * @param string $tx_id Blockchain transaction ID of created withdrawal
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function completeWithdrawal($id, $tx_id) {
        if (strlen($id) > 50) {
            throw new IAE('Invalid length for "$id" when calling WithdrawalApi.completeWithdrawal, must be smaller than or equal to 50');
        }

        if (strlen($id) < 10) {
            throw new IAE('Invalid length for "$id" when calling WithdrawalApi.completeWithdrawal, must be bigger than or equal to 10');
        }

        if (strlen($tx_id) > 80) {
            throw new IAE('Invalid length for "$tx_id" when calling WithdrawalApi.completeWithdrawal, must be smaller than or equal to 80');
        }

        if (strlen($tx_id) < 10) {
            throw new IAE('Invalid length for "$tx_id" when calling WithdrawalApi.completeWithdrawal, must be bigger than or equal to 10');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/offchain/withdrawal/{id}/{txId}";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "PUT", S::parse($rPath, ["id" => $id, "txId" => $tx_id]), $rPath, [], $rHeaders, []
            )
        );
    }
    
    /**
     * Get withdrawals
     *
     * @param float $page_size Max number of items per page is 50.
     * @param string|null $currency Currency of the withdrawal
     * @param string|null $status Status of the withdrawal
     * @param float|null $offset Offset to obtain next page of the data.
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\WithdrawalObject[]
     */
    public function getWithdrawals($page_size, $currency = null, $status = null, $offset = null) {
        if ($page_size > 50) {
            throw new IAE('Invalid value for "$page_size" when calling WithdrawalApi.getWithdrawals, must be smaller than or equal to 50');
        }

        if ($page_size < 1) {
            throw new IAE('Invalid value for "$page_size" when calling WithdrawalApi.getWithdrawals, must be bigger than or equal to 1.');
        }

        if (isset($currency) && strlen($currency) > 30) {
            throw new IAE('Invalid length for "$currency" when calling WithdrawalApi.getWithdrawals, must be smaller than or equal to 30');
        }

        if (isset($currency) && strlen($currency) < 2) {
            throw new IAE('Invalid length for "$currency" when calling WithdrawalApi.getWithdrawals, must be bigger than or equal to 2');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/offchain/withdrawal";
        /** @var \Tatum\Model\WithdrawalObject[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", $rPath, $rPath, [
                    "currency" => isset($currency) ? S::toQueryValue($currency) : null,
                    "status" => isset($status) ? S::toQueryValue($status) : null,
                    "pageSize" => S::toQueryValue($page_size),
                    "offset" => isset($offset) ? S::toQueryValue($offset) : null,
                ], $rHeaders, []
            ), 
            "\Tatum\Model\WithdrawalObject[]"
        );
            
        return $result;
    }
    
    /**
     * Store withdrawal
     *
     * @param \Tatum\Model\Withdrawal $withdrawal 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\WithdrawalResponse
     */
    public function storeWithdrawal($withdrawal) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/offchain/withdrawal";
        /** @var \Tatum\Model\WithdrawalResponse $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $withdrawal
            ), 
            "\Tatum\Model\WithdrawalResponse"
        );
            
        return $result;
    }
    
}
