<?php

/*
 * This file is part of composer/semver.
 * For the full copyright and license information, please view
 * the LICENSE file that was distributed with this source code.
 */

namespace Tatum\Cryptography\Semver\Constraint;
!defined("TATUM-SDK") && exit();

/**
 * Defines the absence of a constraint.
 */
class EmptyConstraint implements ConstraintInterface {
    /** @var string */
    protected $prettyString;

    /**
     * @param ConstraintInterface $provider
     *
     * @return bool
     */
    public function matches(ConstraintInterface $provider) {
        return true;
    }

    /**
     * @param string $prettyString
     */
    public function setPrettyString($prettyString) {
        $this->prettyString = $prettyString;
    }

    /**
     * @return string
     */
    public function getPrettyString() {
        if ($this->prettyString) {
            return $this->prettyString;
        }

        return (string) $this;
    }

    /**
     * @return string
     */
    public function __toString() {
        return "[]";
    }
}
