<?php

/**
 * Abstract Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

use ArrayAccess;
use InvalidArgumentException;
use Tatum\Sdk\Serializer;

abstract class AbstractModel implements ModelInterface, ArrayAccess, \JsonSerializable {
    /**
     * Model name
     */
    protected static $_name = "";

    /**
     * Property definitions
     *
     * @var mixed
     */
    protected static $_definition = [];

    /**
     * Additional properties
     */
    protected $_props = [];

    /**
     * Property values
     */
    protected $_data = [];

    /**
     * {@inheritdoc}
     *
     * @return string[]
     */
    public static function attributeMap(): array {
        return array_map(function ($item) {
            return $item[0];
        }, static::$_definition);
    }

    /**
     * {@inheritDoc}
     *
     * @return string[]
     */
    public static function openAPITypes(): array {
        return array_map(function ($item) {
            return $item[1];
        }, static::$_definition);
    }

    /**
     * {@inheritDoc}
     *
     * @return string[]
     */
    public static function openAPIFormats(): array {
        return array_map(function ($item) {
            return $item[2];
        }, static::$_definition);
    }

    /**
     * {@inheritdoc}
     *
     * @return string[]
     */
    public static function getters(): array {
        return array_map(function ($item) {
            return $item[3];
        }, static::$_definition);
    }

    /**
     * {@inheritdoc}
     *
     * @return string[]
     */
    public static function setters(): array {
        return array_map(function ($item) {
            return $item[4];
        }, static::$_definition);
    }

    /**
     * {@inheritdoc}
     *
     * @return string
     */
    public function modelName(): string {
        return static::$_name;
    }

    /**
     * {@inheritdoc}
     */
    public function valid(): bool {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * {@inheritdoc}
     *
     * @param string $property (optional) Perform checks for this item only; default <b>null</b>
     */
    public function listInvalidProperties($property = null): array {
        // Invalid properties
        $ip = [];

        // Go through all properties
        foreach (static::$_definition as $name => $def) {
            // Perform check for the specified property only
            if (null !== $property && $name !== $property) {
                continue;
            }

            $prop = $def[6];
            $getter = $def[3];

            // Required
            if ($prop["r"]) {
                if (is_null($this->_data[$name])) {
                    $ip[] = "'$name' cannot be null";
                }
            }

            // Enum and not container
            if (isset($prop["e"]) && !isset($prop["c"])) {
                $methodName = $getter . "AllowableValues";
                if (method_exists($this, $methodName)) {
                    $allowed = $this->$methodName();
                    $value = $this->_data[$name];

                    if (!is_null($value) && !in_array($value, $allowed, true)) {
                        $ip[] = sprintf(
                            "'$name' has invalid value '%s', must be one of '%s'",
                            $value,
                            implode("', '", $allowed)
                        );
                    }
                }
            }

            // Pattern
            if (isset($prop["p"])) {
                if ($prop["r"] && !preg_match($prop["p"], $this->_data[$name])) {
                    $ip[] = sprintf(
                        "'$name' must mach pattern %s, '%s' provided",
                        $prop["p"],
                        var_export($this->_data[$name], true)
                    );
                }
            }

            // Minimum
            if (isset($prop["n"])) {
                if (
                    $prop["r"] &&
                    (isset($prop["n"][1])
                        ? // Exclusive
                            $this->_data[$name] <= $prop["n"][0]
                        : // Non-exclusive
                            $this->_data[$name] < $prop["n"][0])
                ) {
                    $ip[] = sprintf(
                        "'$name' must be %s {$prop["n"][0]}",
                        isset($prop["n"][1]) ? "greater than" : "greater than or equal to"
                    );
                }
            }

            // Maximum
            if (isset($prop["x"])) {
                if (
                    $prop["r"] &&
                    (isset($prop["x"][1])
                        ? // Exclusive
                            $this->_data[$name] >= $prop["x"][0]
                        : // Non-exclusive
                            $this->_data[$name] > $prop["x"][0])
                ) {
                    $ip[] = sprintf(
                        "'$name' must be %s {$prop["x"][0]}",
                        isset($prop["x"][1]) ? "smaller than" : "smaller than or equal to"
                    );
                }
            }

            // Minimum length
            if (isset($prop["nl"])) {
                if ($prop["r"] && mb_strlen($this->_data[$name]) < $prop["nl"]) {
                    $ip[] = "'$name' length must be greater than or equal to {$prop["nl"]}";
                }
            }

            // Maximum length
            if (isset($prop["xl"])) {
                if ($prop["r"] && mb_strlen($this->_data[$name]) > $prop["xl"]) {
                    $ip[] = "'$name' length must be smaller than or equal to {$prop["xl"]}";
                }
            }

            // Minimum items
            if (isset($prop["ni"])) {
                if ($prop["r"] && is_array($this->_data[$name]) && count($this->_data[$name]) < $prop["ni"]) {
                    $ip[] = "'$name' count must be greater than or equal to {$prop["ni"]}";
                }
            }

            // Maximum items
            if (isset($prop["xi"])) {
                if ($prop["r"] && is_array($this->_data[$name]) && count($this->_data[$name]) > $prop["xi"]) {
                    $ip[] = "'$name' count must be smaller than or equal to {$prop["xi"]}";
                }
            }
        }

        return $ip;
    }

    /**
     * {@inheritdoc}
     *
     * @return $this
     */
    public function additionalPropertySet($property, $value) {
        if (isset(static::$_definition[$property])) {
            throw new InvalidArgumentException();
        }
        $this->_props[$property] = $property;
        $this->_data[$property] = $value;

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function listAdditionalProperties(): array {
        $data = $this->_data;

        return array_map(function ($key) use ($data) {
            return $data[$key];
        }, $this->_props);
    }

    /**
     * {@inheritdoc}
     */
    public function offsetExists($offset): bool {
        return isset($this->_data[$offset]);
    }

    /**
     * {@inheritdoc}
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) {
        return $this->_data[$offset] ?? null;
    }

    /**
     * {@inheritdoc}
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value): self {
        if (is_null($offset)) {
            throw new \RuntimeException(
                "Appending to a model does not make sense. Provide an explicit property instead"
            );
        } else {
            if (!isset(static::$_definition[$offset])) {
                $this->_props[$offset] = $offset;
            }
            $this->_data[$offset] = $value;
        }

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset): self {
        unset($this->_data[$offset]);

        return $this;
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode()
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() {
        return Serializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     * @throws \JsonException
     */
    public function __toString() {
        return json_encode(Serializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT | JSON_THROW_ON_ERROR);
    }

    /**
     * Store property and perform validation
     *
     * @param string $name  Property name
     * @param mixed  $value Property value
     * @throws \InvalidArgumentException
     *
     * @return $this
     */
    protected function _set($name, $value) {
        if (!isset(static::$_definition[$name])) {
            throw new InvalidArgumentException(sprintf("%s: Property '%s' not declared", get_called_class(), $name));
        }

        // Store
        $this->_data[$name] = $value;

        // Validate
        $issues = $this->listInvalidProperties($name);

        // Something went wrong
        if (count($issues)) {
            throw new InvalidArgumentException(
                sprintf("%s::%s() %s", get_called_class(), static::$_definition[$name][4], implode(", ", $issues))
            );
        }

        return $this;
    }
}
