<?php

/**
 * AlgoTx Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * AlgoTx Model
 */
class AlgoTx extends AbstractModel {

    public const _D = null;
    protected static $_name = "AlgoTx";
    protected static $_definition = [
        "close_rewards" => ["closeRewards", "float", null, "getCloseRewards", "setCloseRewards", null, ["r" => 0]], 
        "closing_amount" => ["closingAmount", "float", null, "getClosingAmount", "setClosingAmount", null, ["r" => 0]], 
        "confirmed_round" => ["confirmedRound", "float", null, "getConfirmedRound", "setConfirmedRound", null, ["r" => 0]], 
        "fee" => ["fee", "float", null, "getFee", "setFee", null, ["r" => 0]], 
        "first_valid" => ["firstValid", "float", null, "getFirstValid", "setFirstValid", null, ["r" => 0]], 
        "genesis_hash" => ["genesisHash", "string", null, "getGenesisHash", "setGenesisHash", null, ["r" => 0]], 
        "genesis_id" => ["genesisId", "string", null, "getGenesisId", "setGenesisId", null, ["r" => 0]], 
        "id" => ["id", "string", null, "getId", "setId", null, ["r" => 0]], 
        "intra_round_offset" => ["intraRoundOffset", "float", null, "getIntraRoundOffset", "setIntraRoundOffset", null, ["r" => 0]], 
        "last_valid" => ["lastValid", "float", null, "getLastValid", "setLastValid", null, ["r" => 0]], 
        "note" => ["note", "string", null, "getNote", "setNote", null, ["r" => 0]], 
        "payment_transaction" => ["paymentTransaction", "object", null, "getPaymentTransaction", "setPaymentTransaction", null, ["r" => 0]], 
        "receiver_rewards" => ["receiverRewards", "float", null, "getReceiverRewards", "setReceiverRewards", null, ["r" => 0]], 
        "round_time" => ["roundTime", "float", null, "getRoundTime", "setRoundTime", null, ["r" => 0]], 
        "sender" => ["sender", "string", null, "getSender", "setSender", null, ["r" => 0]], 
        "sender_rewards" => ["senderRewards", "float", null, "getSenderRewards", "setSenderRewards", null, ["r" => 0]], 
        "signature" => ["signature", "object", null, "getSignature", "setSignature", null, ["r" => 0]], 
        "tx_type" => ["txType", "string", null, "getTxType", "setTxType", null, ["r" => 0]]
    ];

    /**
     * AlgoTx
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get close_rewards
     *
     * @return float|null
     */
    public function getCloseRewards(): ?float {
        return $this->_data["close_rewards"];
    }

    /**
     * Set close_rewards
     * 
     * @param float|null $close_rewards rewards applied to close-remainder-to account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCloseRewards(?float $close_rewards) {
        return $this->_set("close_rewards", $close_rewards);
    }

    /**
     * Get closing_amount
     *
     * @return float|null
     */
    public function getClosingAmount(): ?float {
        return $this->_data["closing_amount"];
    }

    /**
     * Set closing_amount
     * 
     * @param float|null $closing_amount closing amount for transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setClosingAmount(?float $closing_amount) {
        return $this->_set("closing_amount", $closing_amount);
    }

    /**
     * Get confirmed_round
     *
     * @return float|null
     */
    public function getConfirmedRound(): ?float {
        return $this->_data["confirmed_round"];
    }

    /**
     * Set confirmed_round
     * 
     * @param float|null $confirmed_round Round when the transaction was confirmed.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setConfirmedRound(?float $confirmed_round) {
        return $this->_set("confirmed_round", $confirmed_round);
    }

    /**
     * Get fee
     *
     * @return float|null
     */
    public function getFee(): ?float {
        return $this->_data["fee"];
    }

    /**
     * Set fee
     * 
     * @param float|null $fee Transaction fee
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFee(?float $fee) {
        return $this->_set("fee", $fee);
    }

    /**
     * Get first_valid
     *
     * @return float|null
     */
    public function getFirstValid(): ?float {
        return $this->_data["first_valid"];
    }

    /**
     * Set first_valid
     * 
     * @param float|null $first_valid First valid round for this transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFirstValid(?float $first_valid) {
        return $this->_set("first_valid", $first_valid);
    }

    /**
     * Get genesis_hash
     *
     * @return string|null
     */
    public function getGenesisHash(): ?string {
        return $this->_data["genesis_hash"];
    }

    /**
     * Set genesis_hash
     * 
     * @param string|null $genesis_hash Hash of genesis block
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGenesisHash(?string $genesis_hash) {
        return $this->_set("genesis_hash", $genesis_hash);
    }

    /**
     * Get genesis_id
     *
     * @return string|null
     */
    public function getGenesisId(): ?string {
        return $this->_data["genesis_id"];
    }

    /**
     * Set genesis_id
     * 
     * @param string|null $genesis_id genesis block ID.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGenesisId(?string $genesis_id) {
        return $this->_set("genesis_id", $genesis_id);
    }

    /**
     * Get id
     *
     * @return string|null
     */
    public function getId(): ?string {
        return $this->_data["id"];
    }

    /**
     * Set id
     * 
     * @param string|null $id transaction ID
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setId(?string $id) {
        return $this->_set("id", $id);
    }

    /**
     * Get intra_round_offset
     *
     * @return float|null
     */
    public function getIntraRoundOffset(): ?float {
        return $this->_data["intra_round_offset"];
    }

    /**
     * Set intra_round_offset
     * 
     * @param float|null $intra_round_offset Offset into the round where this transaction was confirmed.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setIntraRoundOffset(?float $intra_round_offset) {
        return $this->_set("intra_round_offset", $intra_round_offset);
    }

    /**
     * Get last_valid
     *
     * @return float|null
     */
    public function getLastValid(): ?float {
        return $this->_data["last_valid"];
    }

    /**
     * Set last_valid
     * 
     * @param float|null $last_valid Last valid round for this transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLastValid(?float $last_valid) {
        return $this->_set("last_valid", $last_valid);
    }

    /**
     * Get note
     *
     * @return string|null
     */
    public function getNote(): ?string {
        return $this->_data["note"];
    }

    /**
     * Set note
     * 
     * @param string|null $note Free form data
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setNote(?string $note) {
        return $this->_set("note", $note);
    }

    /**
     * Get payment_transaction
     *
     * @return object|null
     */
    public function getPaymentTransaction(): ?object {
        return $this->_data["payment_transaction"];
    }

    /**
     * Set payment_transaction
     * 
     * @param object|null $payment_transaction payment Transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPaymentTransaction(?object $payment_transaction) {
        return $this->_set("payment_transaction", $payment_transaction);
    }

    /**
     * Get receiver_rewards
     *
     * @return float|null
     */
    public function getReceiverRewards(): ?float {
        return $this->_data["receiver_rewards"];
    }

    /**
     * Set receiver_rewards
     * 
     * @param float|null $receiver_rewards rewards applied to receiver account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setReceiverRewards(?float $receiver_rewards) {
        return $this->_set("receiver_rewards", $receiver_rewards);
    }

    /**
     * Get round_time
     *
     * @return float|null
     */
    public function getRoundTime(): ?float {
        return $this->_data["round_time"];
    }

    /**
     * Set round_time
     * 
     * @param float|null $round_time Time when the block this transaction is in was confirmed.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setRoundTime(?float $round_time) {
        return $this->_set("round_time", $round_time);
    }

    /**
     * Get sender
     *
     * @return string|null
     */
    public function getSender(): ?string {
        return $this->_data["sender"];
    }

    /**
     * Set sender
     * 
     * @param string|null $sender Sender's address
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSender(?string $sender) {
        return $this->_set("sender", $sender);
    }

    /**
     * Get sender_rewards
     *
     * @return float|null
     */
    public function getSenderRewards(): ?float {
        return $this->_data["sender_rewards"];
    }

    /**
     * Set sender_rewards
     * 
     * @param float|null $sender_rewards rewards applied to sender account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSenderRewards(?float $sender_rewards) {
        return $this->_set("sender_rewards", $sender_rewards);
    }

    /**
     * Get signature
     *
     * @return object|null
     */
    public function getSignature(): ?object {
        return $this->_data["signature"];
    }

    /**
     * Set signature
     * 
     * @param object|null $signature signature
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSignature(?object $signature) {
        return $this->_set("signature", $signature);
    }

    /**
     * Get tx_type
     *
     * @return string|null
     */
    public function getTxType(): ?string {
        return $this->_data["tx_type"];
    }

    /**
     * Set tx_type
     * 
     * @param string|null $tx_type indicates what type of transaction this is. Different types have differnet fields.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTxType(?string $tx_type) {
        return $this->_set("tx_type", $tx_type);
    }
}
