<?php

/**
 * BchBlock Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * BchBlock Model
 */
class BchBlock extends AbstractModel {

    public const _D = null;
    protected static $_name = "BchBlock";
    protected static $_definition = [
        "hash" => ["hash", "string", null, "getHash", "setHash", null, ["r" => 0]], 
        "size" => ["size", "float", null, "getSize", "setSize", null, ["r" => 0]], 
        "height" => ["height", "float", null, "getHeight", "setHeight", null, ["r" => 0]], 
        "version" => ["version", "float", null, "getVersion", "setVersion", null, ["r" => 0]], 
        "merkleroot" => ["merkleroot", "string", null, "getMerkleroot", "setMerkleroot", null, ["r" => 0]], 
        "tx" => ["tx", "\Tatum\Model\BchTx[]", null, "getTx", "setTx", null, ["r" => 0, "c" => 1]], 
        "time" => ["time", "float", null, "getTime", "setTime", null, ["r" => 0]], 
        "nonce" => ["nonce", "float", null, "getNonce", "setNonce", null, ["r" => 0]], 
        "difficulty" => ["difficulty", "float", null, "getDifficulty", "setDifficulty", null, ["r" => 0]], 
        "confirmations" => ["confirmations", "float", null, "getConfirmations", "setConfirmations", null, ["r" => 0]], 
        "previousblockhash" => ["previousblockhash", "string", null, "getPreviousblockhash", "setPreviousblockhash", null, ["r" => 0]], 
        "nextblockhash" => ["nextblockhash", "string", null, "getNextblockhash", "setNextblockhash", null, ["r" => 0]]
    ];

    /**
     * BchBlock
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get hash
     *
     * @return string|null
     */
    public function getHash(): ?string {
        return $this->_data["hash"];
    }

    /**
     * Set hash
     * 
     * @param string|null $hash Hash of block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHash(?string $hash) {
        return $this->_set("hash", $hash);
    }

    /**
     * Get size
     *
     * @return float|null
     */
    public function getSize(): ?float {
        return $this->_data["size"];
    }

    /**
     * Set size
     * 
     * @param float|null $size Block size.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSize(?float $size) {
        return $this->_set("size", $size);
    }

    /**
     * Get height
     *
     * @return float|null
     */
    public function getHeight(): ?float {
        return $this->_data["height"];
    }

    /**
     * Set height
     * 
     * @param float|null $height The number of blocks preceding a particular block on a block chain.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHeight(?float $height) {
        return $this->_set("height", $height);
    }

    /**
     * Get version
     *
     * @return float|null
     */
    public function getVersion(): ?float {
        return $this->_data["version"];
    }

    /**
     * Set version
     * 
     * @param float|null $version Block version.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setVersion(?float $version) {
        return $this->_set("version", $version);
    }

    /**
     * Get merkleroot
     *
     * @return string|null
     */
    public function getMerkleroot(): ?string {
        return $this->_data["merkleroot"];
    }

    /**
     * Set merkleroot
     * 
     * @param string|null $merkleroot The root node of a merkle tree, a descendant of all the hashed pairs in the tree.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMerkleroot(?string $merkleroot) {
        return $this->_set("merkleroot", $merkleroot);
    }

    /**
     * Get tx
     *
     * @return \Tatum\Model\BchTx[]|null
     */
    public function getTx(): ?array {
        return $this->_data["tx"];
    }

    /**
     * Set tx
     * 
     * @param \Tatum\Model\BchTx[]|null $tx List of transactions present in the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTx(?array $tx) {
        return $this->_set("tx", $tx);
    }

    /**
     * Get time
     *
     * @return float|null
     */
    public function getTime(): ?float {
        return $this->_data["time"];
    }

    /**
     * Set time
     * 
     * @param float|null $time Time of the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTime(?float $time) {
        return $this->_set("time", $time);
    }

    /**
     * Get nonce
     *
     * @return float|null
     */
    public function getNonce(): ?float {
        return $this->_data["nonce"];
    }

    /**
     * Set nonce
     * 
     * @param float|null $nonce Arbitrary number that is used in Bitcoin's proof of work consensus algorithm.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setNonce(?float $nonce) {
        return $this->_set("nonce", $nonce);
    }

    /**
     * Get difficulty
     *
     * @return float|null
     */
    public function getDifficulty(): ?float {
        return $this->_data["difficulty"];
    }

    /**
     * Set difficulty
     * 
     * @param float|null $difficulty difficulty
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDifficulty(?float $difficulty) {
        return $this->_set("difficulty", $difficulty);
    }

    /**
     * Get confirmations
     *
     * @return float|null
     */
    public function getConfirmations(): ?float {
        return $this->_data["confirmations"];
    }

    /**
     * Set confirmations
     * 
     * @param float|null $confirmations Number of blocks mined after this block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setConfirmations(?float $confirmations) {
        return $this->_set("confirmations", $confirmations);
    }

    /**
     * Get previousblockhash
     *
     * @return string|null
     */
    public function getPreviousblockhash(): ?string {
        return $this->_data["previousblockhash"];
    }

    /**
     * Set previousblockhash
     * 
     * @param string|null $previousblockhash Hash of the previous block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPreviousblockhash(?string $previousblockhash) {
        return $this->_set("previousblockhash", $previousblockhash);
    }

    /**
     * Get nextblockhash
     *
     * @return string|null
     */
    public function getNextblockhash(): ?string {
        return $this->_data["nextblockhash"];
    }

    /**
     * Set nextblockhash
     * 
     * @param string|null $nextblockhash Hash of the next block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setNextblockhash(?string $nextblockhash) {
        return $this->_set("nextblockhash", $nextblockhash);
    }
}
