<?php

/**
 * BtcTx Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * BtcTx Model
 */
class BtcTx extends AbstractModel {

    public const _D = null;
    protected static $_name = "BtcTx";
    protected static $_definition = [
        "hash" => ["hash", "string", null, "getHash", "setHash", null, ["r" => 0]], 
        "hex" => ["hex", "string", null, "getHex", "setHex", null, ["r" => 0]], 
        "witness_hash" => ["witnessHash", "string", null, "getWitnessHash", "setWitnessHash", null, ["r" => 0]], 
        "fee" => ["fee", "float", null, "getFee", "setFee", null, ["r" => 0]], 
        "rate" => ["rate", "float", null, "getRate", "setRate", null, ["r" => 0]], 
        "mtime" => ["mtime", "float", null, "getMtime", "setMtime", null, ["r" => 0]], 
        "block_number" => ["blockNumber", "float", null, "getBlockNumber", "setBlockNumber", null, ["r" => 0]], 
        "block" => ["block", "string", null, "getBlock", "setBlock", null, ["r" => 0]], 
        "time" => ["time", "float", null, "getTime", "setTime", null, ["r" => 0]], 
        "index" => ["index", "float", null, "getIndex", "setIndex", null, ["r" => 0]], 
        "version" => ["version", "float", null, "getVersion", "setVersion", null, ["r" => 0]], 
        "inputs" => ["inputs", "\Tatum\Model\BtcTxInput[]", null, "getInputs", "setInputs", null, ["r" => 0, "c" => 1]], 
        "outputs" => ["outputs", "\Tatum\Model\BtcTxOutput[]", null, "getOutputs", "setOutputs", null, ["r" => 0, "c" => 1]], 
        "locktime" => ["locktime", "float", null, "getLocktime", "setLocktime", null, ["r" => 0]]
    ];

    /**
     * BtcTx
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get hash
     *
     * @return string|null
     */
    public function getHash(): ?string {
        return $this->_data["hash"];
    }

    /**
     * Set hash
     * 
     * @param string|null $hash Transaction hash.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHash(?string $hash) {
        return $this->_set("hash", $hash);
    }

    /**
     * Get hex
     *
     * @return string|null
     */
    public function getHex(): ?string {
        return $this->_data["hex"];
    }

    /**
     * Set hex
     * 
     * @param string|null $hex Transaction hex.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHex(?string $hex) {
        return $this->_set("hex", $hex);
    }

    /**
     * Get witness_hash
     *
     * @return string|null
     */
    public function getWitnessHash(): ?string {
        return $this->_data["witness_hash"];
    }

    /**
     * Set witness_hash
     * 
     * @param string|null $witness_hash Witness hash in case of a SegWit transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setWitnessHash(?string $witness_hash) {
        return $this->_set("witness_hash", $witness_hash);
    }

    /**
     * Get fee
     *
     * @return float|null
     */
    public function getFee(): ?float {
        return $this->_data["fee"];
    }

    /**
     * Set fee
     * 
     * @param float|null $fee Fee paid for this transaction, in satoshis.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFee(?float $fee) {
        return $this->_set("fee", $fee);
    }

    /**
     * Get rate
     *
     * @return float|null
     */
    public function getRate(): ?float {
        return $this->_data["rate"];
    }

    /**
     * Set rate
     * 
     * @param float|null $rate rate
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setRate(?float $rate) {
        return $this->_set("rate", $rate);
    }

    /**
     * Get mtime
     *
     * @return float|null
     */
    public function getMtime(): ?float {
        return $this->_data["mtime"];
    }

    /**
     * Set mtime
     * 
     * @param float|null $mtime mtime
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMtime(?float $mtime) {
        return $this->_set("mtime", $mtime);
    }

    /**
     * Get block_number
     *
     * @return float|null
     */
    public function getBlockNumber(): ?float {
        return $this->_data["block_number"];
    }

    /**
     * Set block_number
     * 
     * @param float|null $block_number Height of the block this transaction belongs to.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockNumber(?float $block_number) {
        return $this->_set("block_number", $block_number);
    }

    /**
     * Get block
     *
     * @return string|null
     */
    public function getBlock(): ?string {
        return $this->_data["block"];
    }

    /**
     * Set block
     * 
     * @param string|null $block Hash of the block this transaction belongs to.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlock(?string $block) {
        return $this->_set("block", $block);
    }

    /**
     * Get time
     *
     * @return float|null
     */
    public function getTime(): ?float {
        return $this->_data["time"];
    }

    /**
     * Set time
     * 
     * @param float|null $time Time of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTime(?float $time) {
        return $this->_set("time", $time);
    }

    /**
     * Get index
     *
     * @return float|null
     */
    public function getIndex(): ?float {
        return $this->_data["index"];
    }

    /**
     * Set index
     * 
     * @param float|null $index Index of the transaction in the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setIndex(?float $index) {
        return $this->_set("index", $index);
    }

    /**
     * Get version
     *
     * @return float|null
     */
    public function getVersion(): ?float {
        return $this->_data["version"];
    }

    /**
     * Set version
     * 
     * @param float|null $version Index of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setVersion(?float $version) {
        return $this->_set("version", $version);
    }

    /**
     * Get inputs
     *
     * @return \Tatum\Model\BtcTxInput[]|null
     */
    public function getInputs(): ?array {
        return $this->_data["inputs"];
    }

    /**
     * Set inputs
     * 
     * @param \Tatum\Model\BtcTxInput[]|null $inputs List of transactions, from which assets are being sent.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setInputs(?array $inputs) {
        return $this->_set("inputs", $inputs);
    }

    /**
     * Get outputs
     *
     * @return \Tatum\Model\BtcTxOutput[]|null
     */
    public function getOutputs(): ?array {
        return $this->_data["outputs"];
    }

    /**
     * Set outputs
     * 
     * @param \Tatum\Model\BtcTxOutput[]|null $outputs List of recipient addresses and amounts to send to each of them.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setOutputs(?array $outputs) {
        return $this->_set("outputs", $outputs);
    }

    /**
     * Get locktime
     *
     * @return float|null
     */
    public function getLocktime(): ?float {
        return $this->_data["locktime"];
    }

    /**
     * Set locktime
     * 
     * @param float|null $locktime Block this transaction was included in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLocktime(?float $locktime) {
        return $this->_set("locktime", $locktime);
    }
}
