<?php

/**
 * CallPolygonSmartContractMethodCaller Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * CallPolygonSmartContractMethodCaller Model
 */
class CallPolygonSmartContractMethodCaller extends AbstractModel {

    public const _D = null;
    protected static $_name = "CallPolygonSmartContractMethodCaller";
    protected static $_definition = [
        "caller" => ["caller", "string", null, "getCaller", "setCaller", null, ["r" => 1, "nl" => 42, "xl" => 42]], 
        "contract_address" => ["contractAddress", "string", null, "getContractAddress", "setContractAddress", null, ["r" => 1, "nl" => 42, "xl" => 42]], 
        "amount" => ["amount", "string", null, "getAmount", "setAmount", null, ["r" => 0, "p" => "/^[+]?((\\d+(\\.\\d*)?)|(\\.\\d+))$/"]], 
        "method_name" => ["methodName", "string", null, "getMethodName", "setMethodName", null, ["r" => 1, "nl" => 1, "xl" => 500]], 
        "method_abi" => ["methodABI", "object", null, "getMethodAbi", "setMethodAbi", null, ["r" => 1]], 
        "params" => ["params", "string[]", null, "getParams", "setParams", null, ["r" => 1, "c" => 1]], 
        "fee" => ["fee", "\Tatum\Model\CustomFee", null, "getFee", "setFee", null, ["r" => 0]]
    ];

    /**
     * CallPolygonSmartContractMethodCaller
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get caller
     *
     * @return string
     */
    public function getCaller(): string {
        return $this->_data["caller"];
    }

    /**
     * Set caller
     * 
     * @param string $caller The address of the account, which will be sender and fee payer of this transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCaller(string $caller) {
        return $this->_set("caller", $caller);
    }

    /**
     * Get contract_address
     *
     * @return string
     */
    public function getContractAddress(): string {
        return $this->_data["contract_address"];
    }

    /**
     * Set contract_address
     * 
     * @param string $contract_address The address of the smart contract
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setContractAddress(string $contract_address) {
        return $this->_set("contract_address", $contract_address);
    }

    /**
     * Get amount
     *
     * @return string|null
     */
    public function getAmount(): ?string {
        return $this->_data["amount"];
    }

    /**
     * Set amount
     * 
     * @param string|null $amount Amount of the assets to be sent.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAmount(?string $amount) {
        return $this->_set("amount", $amount);
    }

    /**
     * Get method_name
     *
     * @return string
     */
    public function getMethodName(): string {
        return $this->_data["method_name"];
    }

    /**
     * Set method_name
     * 
     * @param string $method_name Name of the method to invoke on smart contract.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMethodName(string $method_name) {
        return $this->_set("method_name", $method_name);
    }

    /**
     * Get method_abi
     *
     * @return object
     */
    public function getMethodAbi(): object {
        return $this->_data["method_abi"];
    }

    /**
     * Set method_abi
     * 
     * @param object $method_abi ABI of the method to invoke.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMethodAbi(object $method_abi) {
        return $this->_set("method_abi", $method_abi);
    }

    /**
     * Get params
     *
     * @return string[]
     */
    public function getParams(): array {
        return $this->_data["params"];
    }

    /**
     * Set params
     * 
     * @param string[] $params params
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setParams(array $params) {
        return $this->_set("params", $params);
    }

    /**
     * Get fee
     *
     * @return \Tatum\Model\CustomFee|null
     */
    public function getFee(): ?\Tatum\Model\CustomFee {
        return $this->_data["fee"];
    }

    /**
     * Set fee
     * 
     * @param \Tatum\Model\CustomFee|null $fee fee
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFee(?\Tatum\Model\CustomFee $fee) {
        return $this->_set("fee", $fee);
    }
}
