<?php

/**
 * ChartRequest Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * ChartRequest Model
 */
class ChartRequest extends AbstractModel {

    public const _D = null;
    public const TIME_FRAME_MIN_1 = 'MIN_1';
    public const TIME_FRAME_MIN_3 = 'MIN_3';
    public const TIME_FRAME_MIN_5 = 'MIN_5';
    public const TIME_FRAME_MIN_15 = 'MIN_15';
    public const TIME_FRAME_MIN_30 = 'MIN_30';
    public const TIME_FRAME_HOUR_1 = 'HOUR_1';
    public const TIME_FRAME_HOUR_4 = 'HOUR_4';
    public const TIME_FRAME_HOUR_12 = 'HOUR_12';
    public const TIME_FRAME_DAY = 'DAY';
    public const TIME_FRAME_WEEK = 'WEEK';
    public const TIME_FRAME_MONTH = 'MONTH';
    public const TIME_FRAME_YEAR = 'YEAR';
    protected static $_name = "ChartRequest";
    protected static $_definition = [
        "pair" => ["pair", "string", null, "getPair", "setPair", null, ["r" => 1, "p" => "/^[A-a-zZ0-9_\\-]+\/[A-Za-z0-9_\\-]+$/", "nl" => 3, "xl" => 30]], 
        "from" => ["from", "float", null, "getFrom", "setFrom", null, ["r" => 1, "n" => [0]]], 
        "to" => ["to", "float", null, "getTo", "setTo", null, ["r" => 1, "n" => [0]]], 
        "time_frame" => ["timeFrame", "string", null, "getTimeFrame", "setTimeFrame", null, ["r" => 1, "e" => 1]]
    ];

    /**
     * ChartRequest
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }

    /**
     * Get allowable values
     *
     * @return string[]
     */
    public function getTimeFrameAllowableValues(): array {
        return [
            self::TIME_FRAME_MIN_1,
            self::TIME_FRAME_MIN_3,
            self::TIME_FRAME_MIN_5,
            self::TIME_FRAME_MIN_15,
            self::TIME_FRAME_MIN_30,
            self::TIME_FRAME_HOUR_1,
            self::TIME_FRAME_HOUR_4,
            self::TIME_FRAME_HOUR_12,
            self::TIME_FRAME_DAY,
            self::TIME_FRAME_WEEK,
            self::TIME_FRAME_MONTH,
            self::TIME_FRAME_YEAR,
        ];
    }

    /**
     * Get pair
     *
     * @return string
     */
    public function getPair(): string {
        return $this->_data["pair"];
    }

    /**
     * Set pair
     * 
     * @param string $pair Trading pair
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPair(string $pair) {
        return $this->_set("pair", $pair);
    }

    /**
     * Get from
     *
     * @return float
     */
    public function getFrom(): float {
        return $this->_data["from"];
    }

    /**
     * Set from
     * 
     * @param float $from Start interval in UTC millis.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFrom(float $from) {
        return $this->_set("from", $from);
    }

    /**
     * Get to
     *
     * @return float
     */
    public function getTo(): float {
        return $this->_data["to"];
    }

    /**
     * Set to
     * 
     * @param float $to End interval in UTC millis.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTo(float $to) {
        return $this->_set("to", $to);
    }

    /**
     * Get time_frame
     *
     * @return string
     */
    public function getTimeFrame(): string {
        return $this->_data["time_frame"];
    }

    /**
     * Set time_frame
     * 
     * @param string $time_frame Time frame of the chart.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTimeFrame(string $time_frame) {
        return $this->_set("time_frame", $time_frame);
    }
}
