<?php

/**
 * DogeTx Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * DogeTx Model
 */
class DogeTx extends AbstractModel {

    public const _D = null;
    protected static $_name = "DogeTx";
    protected static $_definition = [
        "hash" => ["hash", "string", null, "getHash", "setHash", null, ["r" => 0]], 
        "size" => ["size", "float", null, "getSize", "setSize", null, ["r" => 0]], 
        "vsize" => ["vsize", "float", null, "getVsize", "setVsize", null, ["r" => 0]], 
        "version" => ["version", "float", null, "getVersion", "setVersion", null, ["r" => 0]], 
        "vin" => ["vin", "\Tatum\Model\DogeTxVinInner[]", null, "getVin", "setVin", null, ["r" => 0, "c" => 1]], 
        "vout" => ["vout", "\Tatum\Model\DogeTxVoutInner[]", null, "getVout", "setVout", null, ["r" => 0, "c" => 1]], 
        "locktime" => ["locktime", "float", null, "getLocktime", "setLocktime", null, ["r" => 0]]
    ];

    /**
     * DogeTx
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get hash
     *
     * @return string|null
     */
    public function getHash(): ?string {
        return $this->_data["hash"];
    }

    /**
     * Set hash
     * 
     * @param string|null $hash Transaction hash.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHash(?string $hash) {
        return $this->_set("hash", $hash);
    }

    /**
     * Get size
     *
     * @return float|null
     */
    public function getSize(): ?float {
        return $this->_data["size"];
    }

    /**
     * Set size
     * 
     * @param float|null $size Size of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSize(?float $size) {
        return $this->_set("size", $size);
    }

    /**
     * Get vsize
     *
     * @return float|null
     */
    public function getVsize(): ?float {
        return $this->_data["vsize"];
    }

    /**
     * Set vsize
     * 
     * @param float|null $vsize vsize
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setVsize(?float $vsize) {
        return $this->_set("vsize", $vsize);
    }

    /**
     * Get version
     *
     * @return float|null
     */
    public function getVersion(): ?float {
        return $this->_data["version"];
    }

    /**
     * Set version
     * 
     * @param float|null $version Index of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setVersion(?float $version) {
        return $this->_set("version", $version);
    }

    /**
     * Get vin
     *
     * @return \Tatum\Model\DogeTxVinInner[]|null
     */
    public function getVin(): ?array {
        return $this->_data["vin"];
    }

    /**
     * Set vin
     * 
     * @param \Tatum\Model\DogeTxVinInner[]|null $vin List of transactions, from which assets are being sent.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setVin(?array $vin) {
        return $this->_set("vin", $vin);
    }

    /**
     * Get vout
     *
     * @return \Tatum\Model\DogeTxVoutInner[]|null
     */
    public function getVout(): ?array {
        return $this->_data["vout"];
    }

    /**
     * Set vout
     * 
     * @param \Tatum\Model\DogeTxVoutInner[]|null $vout List of recipient addresses and amounts to send to each of them.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setVout(?array $vout) {
        return $this->_set("vout", $vout);
    }

    /**
     * Get locktime
     *
     * @return float|null
     */
    public function getLocktime(): ?float {
        return $this->_data["locktime"];
    }

    /**
     * Set locktime
     * 
     * @param float|null $locktime locktime
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLocktime(?float $locktime) {
        return $this->_set("locktime", $locktime);
    }
}
