<?php

/**
 * EgldTx Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * EgldTx Model
 */
class EgldTx extends AbstractModel {

    public const _D = null;
    protected static $_name = "EgldTx";
    protected static $_definition = [
        "type" => ["type", "string", null, "getType", "setType", null, ["r" => 0]], 
        "nonce" => ["nonce", "float", null, "getNonce", "setNonce", null, ["r" => 0]], 
        "round" => ["round", "float", null, "getRound", "setRound", null, ["r" => 0]], 
        "epoch" => ["epoch", "float", null, "getEpoch", "setEpoch", null, ["r" => 0]], 
        "value" => ["value", "string", null, "getValue", "setValue", null, ["r" => 0]], 
        "receiver" => ["receiver", "string", null, "getReceiver", "setReceiver", null, ["r" => 0]], 
        "sender" => ["sender", "string", null, "getSender", "setSender", null, ["r" => 0]], 
        "gas_price" => ["gasPrice", "float", null, "getGasPrice", "setGasPrice", null, ["r" => 0]], 
        "gas_limit" => ["gasLimit", "float", null, "getGasLimit", "setGasLimit", null, ["r" => 0]], 
        "data" => ["data", "string", null, "getData", "setData", null, ["r" => 0]], 
        "signature" => ["signature", "string", null, "getSignature", "setSignature", null, ["r" => 0]], 
        "source_shard" => ["sourceShard", "float", null, "getSourceShard", "setSourceShard", null, ["r" => 0]], 
        "destination_shard" => ["destinationShard", "float", null, "getDestinationShard", "setDestinationShard", null, ["r" => 0]], 
        "block_nonce" => ["blockNonce", "float", null, "getBlockNonce", "setBlockNonce", null, ["r" => 0]], 
        "block_hash" => ["blockHash", "string", null, "getBlockHash", "setBlockHash", null, ["r" => 0]], 
        "miniblock_hash" => ["miniblockHash", "string", null, "getMiniblockHash", "setMiniblockHash", null, ["r" => 0]], 
        "timestamp" => ["timestamp", "float", null, "getTimestamp", "setTimestamp", null, ["r" => 0]], 
        "status" => ["status", "string", null, "getStatus", "setStatus", null, ["r" => 0]], 
        "hyperblock_nonce" => ["hyperblockNonce", "float", null, "getHyperblockNonce", "setHyperblockNonce", null, ["r" => 0]], 
        "hyperblock_hash" => ["hyperblockHash", "string", null, "getHyperblockHash", "setHyperblockHash", null, ["r" => 0]]
    ];

    /**
     * EgldTx
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get type
     *
     * @return string|null
     */
    public function getType(): ?string {
        return $this->_data["type"];
    }

    /**
     * Set type
     * 
     * @param string|null $type Type of transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setType(?string $type) {
        return $this->_set("type", $type);
    }

    /**
     * Get nonce
     *
     * @return float|null
     */
    public function getNonce(): ?float {
        return $this->_data["nonce"];
    }

    /**
     * Set nonce
     * 
     * @param float|null $nonce Nonce of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setNonce(?float $nonce) {
        return $this->_set("nonce", $nonce);
    }

    /**
     * Get round
     *
     * @return float|null
     */
    public function getRound(): ?float {
        return $this->_data["round"];
    }

    /**
     * Set round
     * 
     * @param float|null $round The round number.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setRound(?float $round) {
        return $this->_set("round", $round);
    }

    /**
     * Get epoch
     *
     * @return float|null
     */
    public function getEpoch(): ?float {
        return $this->_data["epoch"];
    }

    /**
     * Set epoch
     * 
     * @param float|null $epoch An epoch is a sequence of consecutive rounds during which the configuration of the network does not change (currently aprox. 24 hrs in length).
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setEpoch(?float $epoch) {
        return $this->_set("epoch", $epoch);
    }

    /**
     * Get value
     *
     * @return string|null
     */
    public function getValue(): ?string {
        return $this->_data["value"];
    }

    /**
     * Set value
     * 
     * @param string|null $value Transferred value.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setValue(?string $value) {
        return $this->_set("value", $value);
    }

    /**
     * Get receiver
     *
     * @return string|null
     */
    public function getReceiver(): ?string {
        return $this->_data["receiver"];
    }

    /**
     * Set receiver
     * 
     * @param string|null $receiver Address of the receiver.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setReceiver(?string $receiver) {
        return $this->_set("receiver", $receiver);
    }

    /**
     * Get sender
     *
     * @return string|null
     */
    public function getSender(): ?string {
        return $this->_data["sender"];
    }

    /**
     * Set sender
     * 
     * @param string|null $sender Address of the sender.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSender(?string $sender) {
        return $this->_set("sender", $sender);
    }

    /**
     * Get gas_price
     *
     * @return float|null
     */
    public function getGasPrice(): ?float {
        return $this->_data["gas_price"];
    }

    /**
     * Set gas_price
     * 
     * @param float|null $gas_price Gas price provided by the sender
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGasPrice(?float $gas_price) {
        return $this->_set("gas_price", $gas_price);
    }

    /**
     * Get gas_limit
     *
     * @return float|null
     */
    public function getGasLimit(): ?float {
        return $this->_data["gas_limit"];
    }

    /**
     * Set gas_limit
     * 
     * @param float|null $gas_limit Gas provided by the sender
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGasLimit(?float $gas_limit) {
        return $this->_set("gas_limit", $gas_limit);
    }

    /**
     * Get data
     *
     * @return string|null
     */
    public function getData(): ?string {
        return $this->_data["data"];
    }

    /**
     * Set data
     * 
     * @param string|null $data Data field in transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setData(?string $data) {
        return $this->_set("data", $data);
    }

    /**
     * Get signature
     *
     * @return string|null
     */
    public function getSignature(): ?string {
        return $this->_data["signature"];
    }

    /**
     * Set signature
     * 
     * @param string|null $signature Signature of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSignature(?string $signature) {
        return $this->_set("signature", $signature);
    }

    /**
     * Get source_shard
     *
     * @return float|null
     */
    public function getSourceShard(): ?float {
        return $this->_data["source_shard"];
    }

    /**
     * Set source_shard
     * 
     * @param float|null $source_shard Source shard.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSourceShard(?float $source_shard) {
        return $this->_set("source_shard", $source_shard);
    }

    /**
     * Get destination_shard
     *
     * @return float|null
     */
    public function getDestinationShard(): ?float {
        return $this->_data["destination_shard"];
    }

    /**
     * Set destination_shard
     * 
     * @param float|null $destination_shard Destination shard.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDestinationShard(?float $destination_shard) {
        return $this->_set("destination_shard", $destination_shard);
    }

    /**
     * Get block_nonce
     *
     * @return float|null
     */
    public function getBlockNonce(): ?float {
        return $this->_data["block_nonce"];
    }

    /**
     * Set block_nonce
     * 
     * @param float|null $block_nonce Nonce of block which contains current transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockNonce(?float $block_nonce) {
        return $this->_set("block_nonce", $block_nonce);
    }

    /**
     * Get block_hash
     *
     * @return string|null
     */
    public function getBlockHash(): ?string {
        return $this->_data["block_hash"];
    }

    /**
     * Set block_hash
     * 
     * @param string|null $block_hash Hash of block which contains current transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockHash(?string $block_hash) {
        return $this->_set("block_hash", $block_hash);
    }

    /**
     * Get miniblock_hash
     *
     * @return string|null
     */
    public function getMiniblockHash(): ?string {
        return $this->_data["miniblock_hash"];
    }

    /**
     * Set miniblock_hash
     * 
     * @param string|null $miniblock_hash Miniblock hash.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMiniblockHash(?string $miniblock_hash) {
        return $this->_set("miniblock_hash", $miniblock_hash);
    }

    /**
     * Get timestamp
     *
     * @return float|null
     */
    public function getTimestamp(): ?float {
        return $this->_data["timestamp"];
    }

    /**
     * Set timestamp
     * 
     * @param float|null $timestamp The unix timestamp for when the block was collated.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTimestamp(?float $timestamp) {
        return $this->_set("timestamp", $timestamp);
    }

    /**
     * Get status
     *
     * @return string|null
     */
    public function getStatus(): ?string {
        return $this->_data["status"];
    }

    /**
     * Set status
     * 
     * @param string|null $status Status of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setStatus(?string $status) {
        return $this->_set("status", $status);
    }

    /**
     * Get hyperblock_nonce
     *
     * @return float|null
     */
    public function getHyperblockNonce(): ?float {
        return $this->_data["hyperblock_nonce"];
    }

    /**
     * Set hyperblock_nonce
     * 
     * @param float|null $hyperblock_nonce Nonce of the hyperblockwhere this transaction was in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHyperblockNonce(?float $hyperblock_nonce) {
        return $this->_set("hyperblock_nonce", $hyperblock_nonce);
    }

    /**
     * Get hyperblock_hash
     *
     * @return string|null
     */
    public function getHyperblockHash(): ?string {
        return $this->_data["hyperblock_hash"];
    }

    /**
     * Set hyperblock_hash
     * 
     * @param string|null $hyperblock_hash Hash of the hyperblock where this transaction was in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHyperblockHash(?string $hyperblock_hash) {
        return $this->_set("hyperblock_hash", $hyperblock_hash);
    }
}
