<?php

/**
 * FlowTx Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * FlowTx Model
 */
class FlowTx extends AbstractModel {

    public const _D = null;
    protected static $_name = "FlowTx";
    protected static $_definition = [
        "reference_block_id" => ["referenceBlockId", "string", null, "getReferenceBlockId", "setReferenceBlockId", null, ["r" => 0]], 
        "script" => ["script", "string", null, "getScript", "setScript", null, ["r" => 0]], 
        "args" => ["args", "\Tatum\Model\FlowTxArgsInner[]", null, "getArgs", "setArgs", null, ["r" => 0, "c" => 1]], 
        "gas_limit" => ["gasLimit", "float", null, "getGasLimit", "setGasLimit", null, ["r" => 0]], 
        "proposal_key" => ["proposalKey", "\Tatum\Model\FlowTxProposalKey", null, "getProposalKey", "setProposalKey", null, ["r" => 0]], 
        "payer" => ["payer", "string", null, "getPayer", "setPayer", null, ["r" => 0]], 
        "payload_signatures" => ["payloadSignatures", "\Tatum\Model\FlowTxPayloadSignaturesInner[]", null, "getPayloadSignatures", "setPayloadSignatures", null, ["r" => 0, "c" => 1]], 
        "envelope_signatures" => ["envelopeSignatures", "\Tatum\Model\FlowTxPayloadSignaturesInner[]", null, "getEnvelopeSignatures", "setEnvelopeSignatures", null, ["r" => 0, "c" => 1]], 
        "status" => ["status", "float", null, "getStatus", "setStatus", null, ["r" => 0]], 
        "status_code" => ["statusCode", "float", null, "getStatusCode", "setStatusCode", null, ["r" => 0]], 
        "error_message" => ["errorMessage", "string", null, "getErrorMessage", "setErrorMessage", null, ["r" => 0]], 
        "events" => ["events", "\Tatum\Model\FlowTxEventsInner[]", null, "getEvents", "setEvents", null, ["r" => 0, "c" => 1]]
    ];

    /**
     * FlowTx
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get reference_block_id
     *
     * @return string|null
     */
    public function getReferenceBlockId(): ?string {
        return $this->_data["reference_block_id"];
    }

    /**
     * Set reference_block_id
     * 
     * @param string|null $reference_block_id Id of the block
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setReferenceBlockId(?string $reference_block_id) {
        return $this->_set("reference_block_id", $reference_block_id);
    }

    /**
     * Get script
     *
     * @return string|null
     */
    public function getScript(): ?string {
        return $this->_data["script"];
    }

    /**
     * Set script
     * 
     * @param string|null $script Script to execute in the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setScript(?string $script) {
        return $this->_set("script", $script);
    }

    /**
     * Get args
     *
     * @return \Tatum\Model\FlowTxArgsInner[]|null
     */
    public function getArgs(): ?array {
        return $this->_data["args"];
    }

    /**
     * Set args
     * 
     * @param \Tatum\Model\FlowTxArgsInner[]|null $args Args to the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setArgs(?array $args) {
        return $this->_set("args", $args);
    }

    /**
     * Get gas_limit
     *
     * @return float|null
     */
    public function getGasLimit(): ?float {
        return $this->_data["gas_limit"];
    }

    /**
     * Set gas_limit
     * 
     * @param float|null $gas_limit Gas limit for the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGasLimit(?float $gas_limit) {
        return $this->_set("gas_limit", $gas_limit);
    }

    /**
     * Get proposal_key
     *
     * @return \Tatum\Model\FlowTxProposalKey|null
     */
    public function getProposalKey(): ?\Tatum\Model\FlowTxProposalKey {
        return $this->_data["proposal_key"];
    }

    /**
     * Set proposal_key
     * 
     * @param \Tatum\Model\FlowTxProposalKey|null $proposal_key proposal_key
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setProposalKey(?\Tatum\Model\FlowTxProposalKey $proposal_key) {
        return $this->_set("proposal_key", $proposal_key);
    }

    /**
     * Get payer
     *
     * @return string|null
     */
    public function getPayer(): ?string {
        return $this->_data["payer"];
    }

    /**
     * Set payer
     * 
     * @param string|null $payer Address from which the assets and fees were debited
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPayer(?string $payer) {
        return $this->_set("payer", $payer);
    }

    /**
     * Get payload_signatures
     *
     * @return \Tatum\Model\FlowTxPayloadSignaturesInner[]|null
     */
    public function getPayloadSignatures(): ?array {
        return $this->_data["payload_signatures"];
    }

    /**
     * Set payload_signatures
     * 
     * @param \Tatum\Model\FlowTxPayloadSignaturesInner[]|null $payload_signatures Array of payload signatures.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPayloadSignatures(?array $payload_signatures) {
        return $this->_set("payload_signatures", $payload_signatures);
    }

    /**
     * Get envelope_signatures
     *
     * @return \Tatum\Model\FlowTxPayloadSignaturesInner[]|null
     */
    public function getEnvelopeSignatures(): ?array {
        return $this->_data["envelope_signatures"];
    }

    /**
     * Set envelope_signatures
     * 
     * @param \Tatum\Model\FlowTxPayloadSignaturesInner[]|null $envelope_signatures Array of envelope signatures.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setEnvelopeSignatures(?array $envelope_signatures) {
        return $this->_set("envelope_signatures", $envelope_signatures);
    }

    /**
     * Get status
     *
     * @return float|null
     */
    public function getStatus(): ?float {
        return $this->_data["status"];
    }

    /**
     * Set status
     * 
     * @param float|null $status Status of the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setStatus(?float $status) {
        return $this->_set("status", $status);
    }

    /**
     * Get status_code
     *
     * @return float|null
     */
    public function getStatusCode(): ?float {
        return $this->_data["status_code"];
    }

    /**
     * Set status_code
     * 
     * @param float|null $status_code Status cofe of the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setStatusCode(?float $status_code) {
        return $this->_set("status_code", $status_code);
    }

    /**
     * Get error_message
     *
     * @return string|null
     */
    public function getErrorMessage(): ?string {
        return $this->_data["error_message"];
    }

    /**
     * Set error_message
     * 
     * @param string|null $error_message error_message
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setErrorMessage(?string $error_message) {
        return $this->_set("error_message", $error_message);
    }

    /**
     * Get events
     *
     * @return \Tatum\Model\FlowTxEventsInner[]|null
     */
    public function getEvents(): ?array {
        return $this->_data["events"];
    }

    /**
     * Set events
     * 
     * @param \Tatum\Model\FlowTxEventsInner[]|null $events events
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setEvents(?array $events) {
        return $this->_set("events", $events);
    }
}
