<?php

/**
 * FreezeTron Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * FreezeTron Model
 */
class FreezeTron extends AbstractModel {

    public const _D = null;
    public const RESOURCE_BANDWIDTH = 'BANDWIDTH';
    public const RESOURCE_ENERGY = 'ENERGY';
    protected static $_name = "FreezeTron";
    protected static $_definition = [
        "from_private_key" => ["fromPrivateKey", "string", null, "getFromPrivateKey", "setFromPrivateKey", null, ["r" => 1, "nl" => 64, "xl" => 64]], 
        "receiver" => ["receiver", "string", null, "getReceiver", "setReceiver", null, ["r" => 1, "nl" => 34, "xl" => 34]], 
        "duration" => ["duration", "float", null, "getDuration", "setDuration", null, ["r" => 1, "n" => [3], "x" => [3]]], 
        "resource" => ["resource", "string", null, "getResource", "setResource", null, ["r" => 1, "e" => 1]], 
        "amount" => ["amount", "string", null, "getAmount", "setAmount", null, ["r" => 1, "p" => "/^[+]?((\\d+(\\.\\d*)?)|(\\.\\d+))$/"]]
    ];

    /**
     * FreezeTron
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }

    /**
     * Get allowable values
     *
     * @return string[]
     */
    public function getResourceAllowableValues(): array {
        return [
            self::RESOURCE_BANDWIDTH,
            self::RESOURCE_ENERGY,
        ];
    }

    /**
     * Get from_private_key
     *
     * @return string
     */
    public function getFromPrivateKey(): string {
        return $this->_data["from_private_key"];
    }

    /**
     * Set from_private_key
     * 
     * @param string $from_private_key Private key of the address, from which the TRX will be sent.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFromPrivateKey(string $from_private_key) {
        return $this->_set("from_private_key", $from_private_key);
    }

    /**
     * Get receiver
     *
     * @return string
     */
    public function getReceiver(): string {
        return $this->_data["receiver"];
    }

    /**
     * Set receiver
     * 
     * @param string $receiver Recipient address of frozen BANDWIDTH or ENERGY.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setReceiver(string $receiver) {
        return $this->_set("receiver", $receiver);
    }

    /**
     * Get duration
     *
     * @return float
     */
    public function getDuration(): float {
        return $this->_data["duration"];
    }

    /**
     * Set duration
     * 
     * @param float $duration Duration of frozen funds, in days<br/>Set this parameter to 3.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDuration(float $duration) {
        return $this->_set("duration", $duration);
    }

    /**
     * Get resource
     *
     * @return string
     */
    public function getResource(): string {
        return $this->_data["resource"];
    }

    /**
     * Set resource
     * 
     * @param string $resource Resource to obtain, BANDWIDTH or ENERGY.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setResource(string $resource) {
        return $this->_set("resource", $resource);
    }

    /**
     * Get amount
     *
     * @return string
     */
    public function getAmount(): string {
        return $this->_data["amount"];
    }

    /**
     * Set amount
     * 
     * @param string $amount Amount to be frozen in TRX.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAmount(string $amount) {
        return $this->_set("amount", $amount);
    }
}
