<?php

/**
 * NftGetTransactErc721_200_response Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * NftGetTransactErc721_200_response Model
 */
class NftGetTransactErc721200Response extends AbstractModel {

    public const _D = null;
    protected static $_name = "NftGetTransactErc721_200_response";
    protected static $_definition = [
        "block_hash" => ["blockHash", "string", null, "getBlockHash", "setBlockHash", null, ["r" => 0]], 
        "status" => ["status", "float", null, "getStatus", "setStatus", null, ["r" => 0]], 
        "block_number" => ["blockNumber", "mixed", null, "getBlockNumber", "setBlockNumber", null, ["r" => 0]], 
        "from" => ["from", "string", null, "getFrom", "setFrom", null, ["r" => 0]], 
        "gas" => ["gas", "float", null, "getGas", "setGas", null, ["r" => 0]], 
        "gas_price" => ["gasPrice", "string", null, "getGasPrice", "setGasPrice", null, ["r" => 0]], 
        "transaction_hash" => ["transactionHash", "string", null, "getTransactionHash", "setTransactionHash", null, ["r" => 0]], 
        "input" => ["input", "string", null, "getInput", "setInput", null, ["r" => 0]], 
        "nonce" => ["nonce", "float", null, "getNonce", "setNonce", null, ["r" => 0]], 
        "to" => ["to", "string", null, "getTo", "setTo", null, ["r" => 0]], 
        "transaction_index" => ["transactionIndex", "mixed", null, "getTransactionIndex", "setTransactionIndex", null, ["r" => 0]], 
        "value" => ["value", "string", null, "getValue", "setValue", null, ["r" => 0]], 
        "gas_used" => ["gasUsed", "mixed", null, "getGasUsed", "setGasUsed", null, ["r" => 0]], 
        "cumulative_gas_used" => ["cumulativeGasUsed", "mixed", null, "getCumulativeGasUsed", "setCumulativeGasUsed", null, ["r" => 0]], 
        "contract_address" => ["contractAddress", "string", null, "getContractAddress", "setContractAddress", null, ["r" => 0]], 
        "logs" => ["logs", "\Tatum\Model\EthTxLog[]", null, "getLogs", "setLogs", null, ["r" => 0, "c" => 1]], 
        "reference_block_id" => ["referenceBlockId", "string", null, "getReferenceBlockId", "setReferenceBlockId", null, ["r" => 0]], 
        "script" => ["script", "string", null, "getScript", "setScript", null, ["r" => 0]], 
        "args" => ["args", "\Tatum\Model\FlowTxArgsInner[]", null, "getArgs", "setArgs", null, ["r" => 0, "c" => 1]], 
        "gas_limit" => ["gasLimit", "float", null, "getGasLimit", "setGasLimit", null, ["r" => 0]], 
        "proposal_key" => ["proposalKey", "\Tatum\Model\FlowTxProposalKey", null, "getProposalKey", "setProposalKey", null, ["r" => 0]], 
        "payer" => ["payer", "string", null, "getPayer", "setPayer", null, ["r" => 0]], 
        "payload_signatures" => ["payloadSignatures", "\Tatum\Model\FlowTxPayloadSignaturesInner[]", null, "getPayloadSignatures", "setPayloadSignatures", null, ["r" => 0, "c" => 1]], 
        "envelope_signatures" => ["envelopeSignatures", "\Tatum\Model\FlowTxPayloadSignaturesInner[]", null, "getEnvelopeSignatures", "setEnvelopeSignatures", null, ["r" => 0, "c" => 1]], 
        "status_code" => ["statusCode", "float", null, "getStatusCode", "setStatusCode", null, ["r" => 0]], 
        "error_message" => ["errorMessage", "string", null, "getErrorMessage", "setErrorMessage", null, ["r" => 0]], 
        "events" => ["events", "\Tatum\Model\FlowTxEventsInner[]", null, "getEvents", "setEvents", null, ["r" => 0, "c" => 1]]
    ];

    /**
     * NftGetTransactErc721200Response
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get block_hash
     *
     * @return string|null
     */
    public function getBlockHash(): ?string {
        return $this->_data["block_hash"];
    }

    /**
     * Set block_hash
     * 
     * @param string|null $block_hash Hash of the block where this transaction was in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockHash(?string $block_hash) {
        return $this->_set("block_hash", $block_hash);
    }

    /**
     * Get status
     *
     * @return float|null
     */
    public function getStatus(): ?float {
        return $this->_data["status"];
    }

    /**
     * Set status
     * 
     * @param float|null $status Status of the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setStatus(?float $status) {
        return $this->_set("status", $status);
    }

    /**
     * Get block_number
     *
     * @return mixed|null
     */
    public function getBlockNumber(): ?mixed {
        return $this->_data["block_number"];
    }

    /**
     * Set block_number
     * 
     * @param mixed|null $block_number Block number where this transaction was in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockNumber(?mixed $block_number) {
        return $this->_set("block_number", $block_number);
    }

    /**
     * Get from
     *
     * @return string|null
     */
    public function getFrom(): ?string {
        return $this->_data["from"];
    }

    /**
     * Set from
     * 
     * @param string|null $from Address of the sender.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFrom(?string $from) {
        return $this->_set("from", $from);
    }

    /**
     * Get gas
     *
     * @return float|null
     */
    public function getGas(): ?float {
        return $this->_data["gas"];
    }

    /**
     * Set gas
     * 
     * @param float|null $gas Gas provided by the sender.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGas(?float $gas) {
        return $this->_set("gas", $gas);
    }

    /**
     * Get gas_price
     *
     * @return string|null
     */
    public function getGasPrice(): ?string {
        return $this->_data["gas_price"];
    }

    /**
     * Set gas_price
     * 
     * @param string|null $gas_price Gas price provided by the sender in wei.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGasPrice(?string $gas_price) {
        return $this->_set("gas_price", $gas_price);
    }

    /**
     * Get transaction_hash
     *
     * @return string|null
     */
    public function getTransactionHash(): ?string {
        return $this->_data["transaction_hash"];
    }

    /**
     * Set transaction_hash
     * 
     * @param string|null $transaction_hash Hash of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactionHash(?string $transaction_hash) {
        return $this->_set("transaction_hash", $transaction_hash);
    }

    /**
     * Get input
     *
     * @return string|null
     */
    public function getInput(): ?string {
        return $this->_data["input"];
    }

    /**
     * Set input
     * 
     * @param string|null $input The data sent along with the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setInput(?string $input) {
        return $this->_set("input", $input);
    }

    /**
     * Get nonce
     *
     * @return float|null
     */
    public function getNonce(): ?float {
        return $this->_data["nonce"];
    }

    /**
     * Set nonce
     * 
     * @param float|null $nonce The number of transactions made by the sender prior to this one.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setNonce(?float $nonce) {
        return $this->_set("nonce", $nonce);
    }

    /**
     * Get to
     *
     * @return string|null
     */
    public function getTo(): ?string {
        return $this->_data["to"];
    }

    /**
     * Set to
     * 
     * @param string|null $to Address of the receiver. 'null' when its a contract creation transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTo(?string $to) {
        return $this->_set("to", $to);
    }

    /**
     * Get transaction_index
     *
     * @return mixed|null
     */
    public function getTransactionIndex(): ?mixed {
        return $this->_data["transaction_index"];
    }

    /**
     * Set transaction_index
     * 
     * @param mixed|null $transaction_index Integer of the transactions index position in the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactionIndex(?mixed $transaction_index) {
        return $this->_set("transaction_index", $transaction_index);
    }

    /**
     * Get value
     *
     * @return string|null
     */
    public function getValue(): ?string {
        return $this->_data["value"];
    }

    /**
     * Set value
     * 
     * @param string|null $value Value transferred in wei.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setValue(?string $value) {
        return $this->_set("value", $value);
    }

    /**
     * Get gas_used
     *
     * @return mixed|null
     */
    public function getGasUsed(): ?mixed {
        return $this->_data["gas_used"];
    }

    /**
     * Set gas_used
     * 
     * @param mixed|null $gas_used The amount of gas used by this specific transaction alone.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGasUsed(?mixed $gas_used) {
        return $this->_set("gas_used", $gas_used);
    }

    /**
     * Get cumulative_gas_used
     *
     * @return mixed|null
     */
    public function getCumulativeGasUsed(): ?mixed {
        return $this->_data["cumulative_gas_used"];
    }

    /**
     * Set cumulative_gas_used
     * 
     * @param mixed|null $cumulative_gas_used The total amount of gas used when this transaction was executed in the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCumulativeGasUsed(?mixed $cumulative_gas_used) {
        return $this->_set("cumulative_gas_used", $cumulative_gas_used);
    }

    /**
     * Get contract_address
     *
     * @return string|null
     */
    public function getContractAddress(): ?string {
        return $this->_data["contract_address"];
    }

    /**
     * Set contract_address
     * 
     * @param string|null $contract_address The contract address created, if the transaction was a contract creation, otherwise null.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setContractAddress(?string $contract_address) {
        return $this->_set("contract_address", $contract_address);
    }

    /**
     * Get logs
     *
     * @return \Tatum\Model\EthTxLog[]|null
     */
    public function getLogs(): ?array {
        return $this->_data["logs"];
    }

    /**
     * Set logs
     * 
     * @param \Tatum\Model\EthTxLog[]|null $logs Log events, that happened in this transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLogs(?array $logs) {
        return $this->_set("logs", $logs);
    }

    /**
     * Get reference_block_id
     *
     * @return string|null
     */
    public function getReferenceBlockId(): ?string {
        return $this->_data["reference_block_id"];
    }

    /**
     * Set reference_block_id
     * 
     * @param string|null $reference_block_id Id of the block
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setReferenceBlockId(?string $reference_block_id) {
        return $this->_set("reference_block_id", $reference_block_id);
    }

    /**
     * Get script
     *
     * @return string|null
     */
    public function getScript(): ?string {
        return $this->_data["script"];
    }

    /**
     * Set script
     * 
     * @param string|null $script Script to execute in the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setScript(?string $script) {
        return $this->_set("script", $script);
    }

    /**
     * Get args
     *
     * @return \Tatum\Model\FlowTxArgsInner[]|null
     */
    public function getArgs(): ?array {
        return $this->_data["args"];
    }

    /**
     * Set args
     * 
     * @param \Tatum\Model\FlowTxArgsInner[]|null $args Args to the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setArgs(?array $args) {
        return $this->_set("args", $args);
    }

    /**
     * Get gas_limit
     *
     * @return float|null
     */
    public function getGasLimit(): ?float {
        return $this->_data["gas_limit"];
    }

    /**
     * Set gas_limit
     * 
     * @param float|null $gas_limit Gas limit for the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGasLimit(?float $gas_limit) {
        return $this->_set("gas_limit", $gas_limit);
    }

    /**
     * Get proposal_key
     *
     * @return \Tatum\Model\FlowTxProposalKey|null
     */
    public function getProposalKey(): ?\Tatum\Model\FlowTxProposalKey {
        return $this->_data["proposal_key"];
    }

    /**
     * Set proposal_key
     * 
     * @param \Tatum\Model\FlowTxProposalKey|null $proposal_key proposal_key
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setProposalKey(?\Tatum\Model\FlowTxProposalKey $proposal_key) {
        return $this->_set("proposal_key", $proposal_key);
    }

    /**
     * Get payer
     *
     * @return string|null
     */
    public function getPayer(): ?string {
        return $this->_data["payer"];
    }

    /**
     * Set payer
     * 
     * @param string|null $payer Address from which the assets and fees were debited
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPayer(?string $payer) {
        return $this->_set("payer", $payer);
    }

    /**
     * Get payload_signatures
     *
     * @return \Tatum\Model\FlowTxPayloadSignaturesInner[]|null
     */
    public function getPayloadSignatures(): ?array {
        return $this->_data["payload_signatures"];
    }

    /**
     * Set payload_signatures
     * 
     * @param \Tatum\Model\FlowTxPayloadSignaturesInner[]|null $payload_signatures Array of payload signatures.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPayloadSignatures(?array $payload_signatures) {
        return $this->_set("payload_signatures", $payload_signatures);
    }

    /**
     * Get envelope_signatures
     *
     * @return \Tatum\Model\FlowTxPayloadSignaturesInner[]|null
     */
    public function getEnvelopeSignatures(): ?array {
        return $this->_data["envelope_signatures"];
    }

    /**
     * Set envelope_signatures
     * 
     * @param \Tatum\Model\FlowTxPayloadSignaturesInner[]|null $envelope_signatures Array of envelope signatures.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setEnvelopeSignatures(?array $envelope_signatures) {
        return $this->_set("envelope_signatures", $envelope_signatures);
    }

    /**
     * Get status_code
     *
     * @return float|null
     */
    public function getStatusCode(): ?float {
        return $this->_data["status_code"];
    }

    /**
     * Set status_code
     * 
     * @param float|null $status_code Status cofe of the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setStatusCode(?float $status_code) {
        return $this->_set("status_code", $status_code);
    }

    /**
     * Get error_message
     *
     * @return string|null
     */
    public function getErrorMessage(): ?string {
        return $this->_data["error_message"];
    }

    /**
     * Set error_message
     * 
     * @param string|null $error_message error_message
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setErrorMessage(?string $error_message) {
        return $this->_set("error_message", $error_message);
    }

    /**
     * Get events
     *
     * @return \Tatum\Model\FlowTxEventsInner[]|null
     */
    public function getEvents(): ?array {
        return $this->_data["events"];
    }

    /**
     * Set events
     * 
     * @param \Tatum\Model\FlowTxEventsInner[]|null $events events
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setEvents(?array $events) {
        return $this->_set("events", $events);
    }
}
