<?php

/**
 * OneTxLog Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * OneTxLog Model
 */
class OneTxLog extends AbstractModel {

    public const _D = null;
    protected static $_name = "OneTxLog";
    protected static $_definition = [
        "address" => ["address", "string", null, "getAddress", "setAddress", null, ["r" => 0]], 
        "topics" => ["topics", "string[]", null, "getTopics", "setTopics", null, ["r" => 0, "c" => 1]], 
        "data" => ["data", "string", null, "getData", "setData", null, ["r" => 0]], 
        "log_index" => ["logIndex", "float", null, "getLogIndex", "setLogIndex", null, ["r" => 0]], 
        "block_number" => ["blockNumber", "float", null, "getBlockNumber", "setBlockNumber", null, ["r" => 0]], 
        "block_hash" => ["blockHash", "string", null, "getBlockHash", "setBlockHash", null, ["r" => 0]], 
        "transaction_index" => ["transactionIndex", "float", null, "getTransactionIndex", "setTransactionIndex", null, ["r" => 0]], 
        "transaction_hash" => ["transactionHash", "string", null, "getTransactionHash", "setTransactionHash", null, ["r" => 0]]
    ];

    /**
     * OneTxLog
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get address
     *
     * @return string|null
     */
    public function getAddress(): ?string {
        return $this->_data["address"];
    }

    /**
     * Set address
     * 
     * @param string|null $address From which this event originated from.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAddress(?string $address) {
        return $this->_set("address", $address);
    }

    /**
     * Get topics
     *
     * @return string[]|null
     */
    public function getTopics(): ?array {
        return $this->_data["topics"];
    }

    /**
     * Set topics
     * 
     * @param string[]|null $topics An array with max 4 32 Byte topics, topic 1-3 contains indexed parameters of the log.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTopics(?array $topics) {
        return $this->_set("topics", $topics);
    }

    /**
     * Get data
     *
     * @return string|null
     */
    public function getData(): ?string {
        return $this->_data["data"];
    }

    /**
     * Set data
     * 
     * @param string|null $data The data containing non-indexed log parameter.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setData(?string $data) {
        return $this->_set("data", $data);
    }

    /**
     * Get log_index
     *
     * @return float|null
     */
    public function getLogIndex(): ?float {
        return $this->_data["log_index"];
    }

    /**
     * Set log_index
     * 
     * @param float|null $log_index Integer of the event index position in the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLogIndex(?float $log_index) {
        return $this->_set("log_index", $log_index);
    }

    /**
     * Get block_number
     *
     * @return float|null
     */
    public function getBlockNumber(): ?float {
        return $this->_data["block_number"];
    }

    /**
     * Set block_number
     * 
     * @param float|null $block_number Block number where this transaction was in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockNumber(?float $block_number) {
        return $this->_set("block_number", $block_number);
    }

    /**
     * Get block_hash
     *
     * @return string|null
     */
    public function getBlockHash(): ?string {
        return $this->_data["block_hash"];
    }

    /**
     * Set block_hash
     * 
     * @param string|null $block_hash Hash of the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockHash(?string $block_hash) {
        return $this->_set("block_hash", $block_hash);
    }

    /**
     * Get transaction_index
     *
     * @return float|null
     */
    public function getTransactionIndex(): ?float {
        return $this->_data["transaction_index"];
    }

    /**
     * Set transaction_index
     * 
     * @param float|null $transaction_index Integer of the transaction’s index position, the event was created in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactionIndex(?float $transaction_index) {
        return $this->_set("transaction_index", $transaction_index);
    }

    /**
     * Get transaction_hash
     *
     * @return string|null
     */
    public function getTransactionHash(): ?string {
        return $this->_data["transaction_hash"];
    }

    /**
     * Set transaction_hash
     * 
     * @param string|null $transaction_hash Hash of the transaction this event was created in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactionHash(?string $transaction_hash) {
        return $this->_set("transaction_hash", $transaction_hash);
    }
}
