<?php

/**
 * PendingTransaction Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * PendingTransaction Model
 */
class PendingTransaction extends AbstractModel {

    public const _D = null;
    public const CHAIN_BNB = 'BNB';
    public const CHAIN_BTC = 'BTC';
    public const CHAIN_ETH = 'ETH';
    public const CHAIN_XLM = 'XLM';
    public const CHAIN_XRP = 'XRP';
    public const CHAIN_BCH = 'BCH';
    public const CHAIN_LTC = 'LTC';
    public const CHAIN_DOGE = 'DOGE';
    public const CHAIN_VET = 'VET';
    public const CHAIN_BSC = 'BSC';
    public const CHAIN_MATIC = 'MATIC';
    public const CHAIN_CELO = 'CELO';
    public const CHAIN_FLOW = 'FLOW';
    public const CHAIN_TRON = 'TRON';
    public const CHAIN_ONE = 'ONE';
    public const CHAIN_XDC = 'XDC';
    public const CHAIN_EGLD = 'EGLD';
    public const CHAIN_KLAY = 'KLAY';
    public const CHAIN_SOL = 'SOL';
    protected static $_name = "PendingTransaction";
    protected static $_definition = [
        "id" => ["id", "string", null, "getId", "setId", null, ["r" => 1]], 
        "chain" => ["chain", "string", null, "getChain", "setChain", null, ["r" => 1, "e" => 1]], 
        "hashes" => ["hashes", "string[]", null, "getHashes", "setHashes", null, ["r" => 1, "c" => 1]], 
        "serialized_transaction" => ["serializedTransaction", "string", null, "getSerializedTransaction", "setSerializedTransaction", null, ["r" => 1]], 
        "withdrawal_id" => ["withdrawalId", "string", null, "getWithdrawalId", "setWithdrawalId", null, ["r" => 0]], 
        "index" => ["index", "float", null, "getIndex", "setIndex", null, ["r" => 0, "n" => [0]]], 
        "tx_id" => ["txId", "string", null, "getTxId", "setTxId", null, ["r" => 0]], 
        "withdrawal_responses" => ["withdrawalResponses", "\Tatum\Model\ResponseData[]", null, "getWithdrawalResponses", "setWithdrawalResponses", null, ["r" => 0, "c" => 1]]
    ];

    /**
     * PendingTransaction
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }

    /**
     * Get allowable values
     *
     * @return string[]
     */
    public function getChainAllowableValues(): array {
        return [
            self::CHAIN_BNB,
            self::CHAIN_BTC,
            self::CHAIN_ETH,
            self::CHAIN_XLM,
            self::CHAIN_XRP,
            self::CHAIN_BCH,
            self::CHAIN_LTC,
            self::CHAIN_DOGE,
            self::CHAIN_VET,
            self::CHAIN_BSC,
            self::CHAIN_MATIC,
            self::CHAIN_CELO,
            self::CHAIN_FLOW,
            self::CHAIN_TRON,
            self::CHAIN_ONE,
            self::CHAIN_XDC,
            self::CHAIN_EGLD,
            self::CHAIN_KLAY,
            self::CHAIN_SOL,
        ];
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId(): string {
        return $this->_data["id"];
    }

    /**
     * Set id
     * 
     * @param string $id ID of the pending transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setId(string $id) {
        return $this->_set("id", $id);
    }

    /**
     * Get chain
     *
     * @return string
     */
    public function getChain(): string {
        return $this->_data["chain"];
    }

    /**
     * Set chain
     * 
     * @param string $chain Blockchain of the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setChain(string $chain) {
        return $this->_set("chain", $chain);
    }

    /**
     * Get hashes
     *
     * @return string[]
     */
    public function getHashes(): array {
        return $this->_data["hashes"];
    }

    /**
     * Set hashes
     * 
     * @param string[] $hashes List of the signature Ids to be used to sign transaction. Those hashes should be in order of signing for the BTC, LTC or BCH blockchains.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHashes(array $hashes) {
        return $this->_set("hashes", $hashes);
    }

    /**
     * Get serialized_transaction
     *
     * @return string
     */
    public function getSerializedTransaction(): string {
        return $this->_data["serialized_transaction"];
    }

    /**
     * Set serialized_transaction
     * 
     * @param string $serialized_transaction Serialized data of the transaction to be signed. It can be JSON, HEX or any other representation based on the blockchain.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSerializedTransaction(string $serialized_transaction) {
        return $this->_set("serialized_transaction", $serialized_transaction);
    }

    /**
     * Get withdrawal_id
     *
     * @return string|null
     */
    public function getWithdrawalId(): ?string {
        return $this->_data["withdrawal_id"];
    }

    /**
     * Set withdrawal_id
     * 
     * @param string|null $withdrawal_id ID of the pending off-chain withdrawal connected to this transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setWithdrawalId(?string $withdrawal_id) {
        return $this->_set("withdrawal_id", $withdrawal_id);
    }

    /**
     * Get index
     *
     * @return float|null
     */
    public function getIndex(): ?float {
        return $this->_data["index"];
    }

    /**
     * Set index
     * 
     * @param float|null $index In case of mnemonic type of signature Id, this is the index to the specific account that should be used for signature.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setIndex(?float $index) {
        return $this->_set("index", $index);
    }

    /**
     * Get tx_id
     *
     * @return string|null
     */
    public function getTxId(): ?string {
        return $this->_data["tx_id"];
    }

    /**
     * Set tx_id
     * 
     * @param string|null $tx_id TX hash of successful transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTxId(?string $tx_id) {
        return $this->_set("tx_id", $tx_id);
    }

    /**
     * Get withdrawal_responses
     *
     * @return \Tatum\Model\ResponseData[]|null
     */
    public function getWithdrawalResponses(): ?array {
        return $this->_data["withdrawal_responses"];
    }

    /**
     * Set withdrawal_responses
     * 
     * @param \Tatum\Model\ResponseData[]|null $withdrawal_responses Additional information used for BTC, LTC, DOGE and BCH off-chain to blockchain transactions.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setWithdrawalResponses(?array $withdrawal_responses) {
        return $this->_set("withdrawal_responses", $withdrawal_responses);
    }
}
