<?php

/**
 * TransferXrpBlockchainAssetKMS Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * TransferXrpBlockchainAssetKMS Model
 */
class TransferXrpBlockchainAssetKMS extends AbstractModel {

    public const _D = null;
    protected static $_name = "TransferXrpBlockchainAssetKMS";
    protected static $_definition = [
        "from_account" => ["fromAccount", "string", null, "getFromAccount", "setFromAccount", null, ["r" => 1, "nl" => 33, "xl" => 34]], 
        "to" => ["to", "string", null, "getTo", "setTo", null, ["r" => 1, "nl" => 33, "xl" => 34]], 
        "amount" => ["amount", "string", null, "getAmount", "setAmount", null, ["r" => 1, "p" => "/^[+]?((\\d+(\\.\\d*)?)|(\\.\\d+))$/"]], 
        "signature_id" => ["signatureId", "string", 'uuid', "getSignatureId", "setSignatureId", null, ["r" => 1]], 
        "fee" => ["fee", "string", null, "getFee", "setFee", null, ["r" => 0, "p" => "/^[+]?((\\d+(\\.\\d*)?)|(\\.\\d+))$/"]], 
        "source_tag" => ["sourceTag", "int", null, "getSourceTag", "setSourceTag", null, ["r" => 0]], 
        "destination_tag" => ["destinationTag", "int", null, "getDestinationTag", "setDestinationTag", null, ["r" => 0]], 
        "issuer_account" => ["issuerAccount", "string", null, "getIssuerAccount", "setIssuerAccount", null, ["r" => 1, "nl" => 33, "xl" => 34]], 
        "token" => ["token", "string", null, "getToken", "setToken", null, ["r" => 1, "p" => "/^[A-F0-9]{40}$/", "nl" => 40, "xl" => 40]]
    ];

    /**
     * TransferXrpBlockchainAssetKMS
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get from_account
     *
     * @return string
     */
    public function getFromAccount(): string {
        return $this->_data["from_account"];
    }

    /**
     * Set from_account
     * 
     * @param string $from_account XRP account address. Must be the one used for generating deposit tags.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFromAccount(string $from_account) {
        return $this->_set("from_account", $from_account);
    }

    /**
     * Get to
     *
     * @return string
     */
    public function getTo(): string {
        return $this->_data["to"];
    }

    /**
     * Set to
     * 
     * @param string $to Blockchain address to send assets
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTo(string $to) {
        return $this->_set("to", $to);
    }

    /**
     * Get amount
     *
     * @return string
     */
    public function getAmount(): string {
        return $this->_data["amount"];
    }

    /**
     * Set amount
     * 
     * @param string $amount Amount to be sent, in XRP.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAmount(string $amount) {
        return $this->_set("amount", $amount);
    }

    /**
     * Get signature_id
     *
     * @return string
     */
    public function getSignatureId(): string {
        return $this->_data["signature_id"];
    }

    /**
     * Set signature_id
     * 
     * @param string $signature_id Identifier of the secret associated in signing application. Secret, or signature Id must be present.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSignatureId(string $signature_id) {
        return $this->_set("signature_id", $signature_id);
    }

    /**
     * Get fee
     *
     * @return string|null
     */
    public function getFee(): ?string {
        return $this->_data["fee"];
    }

    /**
     * Set fee
     * 
     * @param string|null $fee Fee to be paid, in XRP. If omitted, current fee will be calculated.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFee(?string $fee) {
        return $this->_set("fee", $fee);
    }

    /**
     * Get source_tag
     *
     * @return int|null
     */
    public function getSourceTag(): ?int {
        return $this->_data["source_tag"];
    }

    /**
     * Set source_tag
     * 
     * @param int|null $source_tag Source tag of sender account, if any.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSourceTag(?int $source_tag) {
        return $this->_set("source_tag", $source_tag);
    }

    /**
     * Get destination_tag
     *
     * @return int|null
     */
    public function getDestinationTag(): ?int {
        return $this->_data["destination_tag"];
    }

    /**
     * Set destination_tag
     * 
     * @param int|null $destination_tag Destination tag of recipient account, if any.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDestinationTag(?int $destination_tag) {
        return $this->_set("destination_tag", $destination_tag);
    }

    /**
     * Get issuer_account
     *
     * @return string
     */
    public function getIssuerAccount(): string {
        return $this->_data["issuer_account"];
    }

    /**
     * Set issuer_account
     * 
     * @param string $issuer_account Blockchain address of the issuer of the assets to create trust line for.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setIssuerAccount(string $issuer_account) {
        return $this->_set("issuer_account", $issuer_account);
    }

    /**
     * Get token
     *
     * @return string
     */
    public function getToken(): string {
        return $this->_data["token"];
    }

    /**
     * Set token
     * 
     * @param string $token Asset name. Must be 160bit HEX string, e.g. SHA1.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setToken(string $token) {
        return $this->_set("token", $token);
    }
}
