<?php

/**
 * UiTokenAmount Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * UiTokenAmount Model
 */
class UiTokenAmount extends AbstractModel {

    public const _D = null;
    protected static $_name = "UiTokenAmount";
    protected static $_definition = [
        "amount" => ["amount", "string", null, "getAmount", "setAmount", null, ["r" => 0]], 
        "decimals" => ["decimals", "float", null, "getDecimals", "setDecimals", null, ["r" => 0]], 
        "ui_amount" => ["uiAmount", "mixed", null, "getUiAmount", "setUiAmount", null, ["r" => 0]], 
        "ui_amount_string" => ["uiAmountString", "string", null, "getUiAmountString", "setUiAmountString", null, ["r" => 0]]
    ];

    /**
     * UiTokenAmount
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get amount
     *
     * @return string|null
     */
    public function getAmount(): ?string {
        return $this->_data["amount"];
    }

    /**
     * Set amount
     * 
     * @param string|null $amount Raw amount of tokens as a string, ignoring decimals.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAmount(?string $amount) {
        return $this->_set("amount", $amount);
    }

    /**
     * Get decimals
     *
     * @return float|null
     */
    public function getDecimals(): ?float {
        return $this->_data["decimals"];
    }

    /**
     * Set decimals
     * 
     * @param float|null $decimals Number of decimals configured for token's mint.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDecimals(?float $decimals) {
        return $this->_set("decimals", $decimals);
    }

    /**
     * Get ui_amount
     *
     * @return mixed|null
     */
    public function getUiAmount(): ?mixed {
        return $this->_data["ui_amount"];
    }

    /**
     * Set ui_amount
     * 
     * @param mixed|null $ui_amount Token amount as a float, accounting for decimals.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setUiAmount(?mixed $ui_amount) {
        return $this->_set("ui_amount", $ui_amount);
    }

    /**
     * Get ui_amount_string
     *
     * @return string|null
     */
    public function getUiAmountString(): ?string {
        return $this->_data["ui_amount_string"];
    }

    /**
     * Set ui_amount_string
     * 
     * @param string|null $ui_amount_string Token amount as a string, accounting for decimals.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setUiAmountString(?string $ui_amount_string) {
        return $this->_set("ui_amount_string", $ui_amount_string);
    }
}
