<?php

/**
 * XrpAccount_account_data Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XrpAccount_account_data Model
 * 
 * @description The AccountRoot ledger object with this account's information, as stored in the ledger.
 */
class XrpAccountAccountData extends AbstractModel {

    public const _D = null;
    protected static $_name = "XrpAccount_account_data";
    protected static $_definition = [
        "account" => ["Account", "string", null, "getAccount", "setAccount", null, ["r" => 0]], 
        "balance" => ["Balance", "string", null, "getBalance", "setBalance", null, ["r" => 0]], 
        "flags" => ["Flags", "float", null, "getFlags", "setFlags", null, ["r" => 0]], 
        "ledger_entry_type" => ["LedgerEntryType", "string", null, "getLedgerEntryType", "setLedgerEntryType", null, ["r" => 0]], 
        "owner_count" => ["OwnerCount", "float", null, "getOwnerCount", "setOwnerCount", null, ["r" => 0]], 
        "previous_txn_id" => ["PreviousTxnID", "string", null, "getPreviousTxnId", "setPreviousTxnId", null, ["r" => 0]], 
        "previous_txn_lgr_seq" => ["PreviousTxnLgrSeq", "float", null, "getPreviousTxnLgrSeq", "setPreviousTxnLgrSeq", null, ["r" => 0]], 
        "sequence" => ["Sequence", "float", null, "getSequence", "setSequence", null, ["r" => 0]], 
        "index" => ["index", "string", null, "getIndex", "setIndex", null, ["r" => 0]]
    ];

    /**
     * XrpAccountAccountData
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get account
     *
     * @return string|null
     */
    public function getAccount(): ?string {
        return $this->_data["account"];
    }

    /**
     * Set account
     * 
     * @param string|null $account The identifying address of this account, such as rf1BiGeXwwQoi8Z2ueFYTEXSwuJYfV2Jpn.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAccount(?string $account) {
        return $this->_set("account", $account);
    }

    /**
     * Get balance
     *
     * @return string|null
     */
    public function getBalance(): ?string {
        return $this->_data["balance"];
    }

    /**
     * Set balance
     * 
     * @param string|null $balance The account's current XRP balance in drops, represented as a string.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBalance(?string $balance) {
        return $this->_set("balance", $balance);
    }

    /**
     * Get flags
     *
     * @return float|null
     */
    public function getFlags(): ?float {
        return $this->_data["flags"];
    }

    /**
     * Set flags
     * 
     * @param float|null $flags A bit-map of boolean flags enabled for this account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFlags(?float $flags) {
        return $this->_set("flags", $flags);
    }

    /**
     * Get ledger_entry_type
     *
     * @return string|null
     */
    public function getLedgerEntryType(): ?string {
        return $this->_data["ledger_entry_type"];
    }

    /**
     * Set ledger_entry_type
     * 
     * @param string|null $ledger_entry_type The value 0x0061, mapped to the string AccountRoot, indicates that this is an AccountRoot object.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLedgerEntryType(?string $ledger_entry_type) {
        return $this->_set("ledger_entry_type", $ledger_entry_type);
    }

    /**
     * Get owner_count
     *
     * @return float|null
     */
    public function getOwnerCount(): ?float {
        return $this->_data["owner_count"];
    }

    /**
     * Set owner_count
     * 
     * @param float|null $owner_count The number of objects this account owns in the ledger, which contributes to its owner reserve.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setOwnerCount(?float $owner_count) {
        return $this->_set("owner_count", $owner_count);
    }

    /**
     * Get previous_txn_id
     *
     * @return string|null
     */
    public function getPreviousTxnId(): ?string {
        return $this->_data["previous_txn_id"];
    }

    /**
     * Set previous_txn_id
     * 
     * @param string|null $previous_txn_id The identifying hash of the transaction that most recently modified this object.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPreviousTxnId(?string $previous_txn_id) {
        return $this->_set("previous_txn_id", $previous_txn_id);
    }

    /**
     * Get previous_txn_lgr_seq
     *
     * @return float|null
     */
    public function getPreviousTxnLgrSeq(): ?float {
        return $this->_data["previous_txn_lgr_seq"];
    }

    /**
     * Set previous_txn_lgr_seq
     * 
     * @param float|null $previous_txn_lgr_seq The index of the ledger that contains the transaction that most recently modified this object.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setPreviousTxnLgrSeq(?float $previous_txn_lgr_seq) {
        return $this->_set("previous_txn_lgr_seq", $previous_txn_lgr_seq);
    }

    /**
     * Get sequence
     *
     * @return float|null
     */
    public function getSequence(): ?float {
        return $this->_data["sequence"];
    }

    /**
     * Set sequence
     * 
     * @param float|null $sequence The sequence number of the next valid transaction for this account. (Each account starts with Sequence = 1 and increases each time a transaction is made.)
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSequence(?float $sequence) {
        return $this->_set("sequence", $sequence);
    }

    /**
     * Get index
     *
     * @return string|null
     */
    public function getIndex(): ?string {
        return $this->_data["index"];
    }

    /**
     * Set index
     * 
     * @param string|null $index index
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setIndex(?string $index) {
        return $this->_set("index", $index);
    }
}
