<?php

/**
 * XrpAccountTx Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XrpAccountTx Model
 */
class XrpAccountTx extends AbstractModel {

    public const _D = null;
    protected static $_name = "XrpAccountTx";
    protected static $_definition = [
        "account" => ["account", "string", null, "getAccount", "setAccount", null, ["r" => 0]], 
        "ledger_index_max" => ["ledger_index_max", "float", null, "getLedgerIndexMax", "setLedgerIndexMax", null, ["r" => 0]], 
        "ledger_index_min" => ["ledger_index_min", "float", null, "getLedgerIndexMin", "setLedgerIndexMin", null, ["r" => 0]], 
        "marker" => ["marker", "\Tatum\Model\XrpAccountTxMarker", null, "getMarker", "setMarker", null, ["r" => 0]], 
        "transactions" => ["transactions", "\Tatum\Model\XrpAccountTxTransactionsInner[]", null, "getTransactions", "setTransactions", null, ["r" => 0, "c" => 1]]
    ];

    /**
     * XrpAccountTx
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get account
     *
     * @return string|null
     */
    public function getAccount(): ?string {
        return $this->_data["account"];
    }

    /**
     * Set account
     * 
     * @param string|null $account Unique Address identifying the related account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAccount(?string $account) {
        return $this->_set("account", $account);
    }

    /**
     * Get ledger_index_max
     *
     * @return float|null
     */
    public function getLedgerIndexMax(): ?float {
        return $this->_data["ledger_index_max"];
    }

    /**
     * Set ledger_index_max
     * 
     * @param float|null $ledger_index_max The ledger index of the earliest ledger actually searched for transactions.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLedgerIndexMax(?float $ledger_index_max) {
        return $this->_set("ledger_index_max", $ledger_index_max);
    }

    /**
     * Get ledger_index_min
     *
     * @return float|null
     */
    public function getLedgerIndexMin(): ?float {
        return $this->_data["ledger_index_min"];
    }

    /**
     * Set ledger_index_min
     * 
     * @param float|null $ledger_index_min The ledger index of the most recent ledger actually searched for transactions.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLedgerIndexMin(?float $ledger_index_min) {
        return $this->_set("ledger_index_min", $ledger_index_min);
    }

    /**
     * Get marker
     *
     * @return \Tatum\Model\XrpAccountTxMarker|null
     */
    public function getMarker(): ?\Tatum\Model\XrpAccountTxMarker {
        return $this->_data["marker"];
    }

    /**
     * Set marker
     * 
     * @param \Tatum\Model\XrpAccountTxMarker|null $marker marker
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMarker(?\Tatum\Model\XrpAccountTxMarker $marker) {
        return $this->_set("marker", $marker);
    }

    /**
     * Get transactions
     *
     * @return \Tatum\Model\XrpAccountTxTransactionsInner[]|null
     */
    public function getTransactions(): ?array {
        return $this->_data["transactions"];
    }

    /**
     * Set transactions
     * 
     * @param \Tatum\Model\XrpAccountTxTransactionsInner[]|null $transactions Array of transactions matching the request's criteria, as explained below.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactions(?array $transactions) {
        return $this->_set("transactions", $transactions);
    }
}
