<?php

/**
 * XrpFee_levels Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XrpFee_levels Model
 * 
 * @description Various information about the transaction cost, in fee levels. The ratio in fee levels applies to any transaction relative to the minimum cost of that particular transaction.
 */
class XrpFeeLevels extends AbstractModel {

    public const _D = null;
    protected static $_name = "XrpFee_levels";
    protected static $_definition = [
        "median_level" => ["median_level", "string", null, "getMedianLevel", "setMedianLevel", null, ["r" => 0]], 
        "minimum_level" => ["minimum_level", "string", null, "getMinimumLevel", "setMinimumLevel", null, ["r" => 0]], 
        "open_ledger_level" => ["open_ledger_level", "string", null, "getOpenLedgerLevel", "setOpenLedgerLevel", null, ["r" => 0]], 
        "reference_level" => ["reference_level", "string", null, "getReferenceLevel", "setReferenceLevel", null, ["r" => 0]]
    ];

    /**
     * XrpFeeLevels
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get median_level
     *
     * @return string|null
     */
    public function getMedianLevel(): ?string {
        return $this->_data["median_level"];
    }

    /**
     * Set median_level
     * 
     * @param string|null $median_level The median transaction cost among transactions in the previous validated ledger, represented in fee levels.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMedianLevel(?string $median_level) {
        return $this->_set("median_level", $median_level);
    }

    /**
     * Get minimum_level
     *
     * @return string|null
     */
    public function getMinimumLevel(): ?string {
        return $this->_data["minimum_level"];
    }

    /**
     * Set minimum_level
     * 
     * @param string|null $minimum_level The minimum transaction cost required to be queued for a future ledger, represented in fee levels.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMinimumLevel(?string $minimum_level) {
        return $this->_set("minimum_level", $minimum_level);
    }

    /**
     * Get open_ledger_level
     *
     * @return string|null
     */
    public function getOpenLedgerLevel(): ?string {
        return $this->_data["open_ledger_level"];
    }

    /**
     * Set open_ledger_level
     * 
     * @param string|null $open_ledger_level The minimum transaction cost required to be included in the current open ledger, represented in fee levels.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setOpenLedgerLevel(?string $open_ledger_level) {
        return $this->_set("open_ledger_level", $open_ledger_level);
    }

    /**
     * Get reference_level
     *
     * @return string|null
     */
    public function getReferenceLevel(): ?string {
        return $this->_data["reference_level"];
    }

    /**
     * Set reference_level
     * 
     * @param string|null $reference_level The equivalent of the minimum transaction cost, represented in fee levels.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setReferenceLevel(?string $reference_level) {
        return $this->_set("reference_level", $reference_level);
    }
}
