<?php

/**
 * Configuration
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Sdk;
!defined("TATUM-SDK") && exit();

use Tatum\Sdk\Debugger;

/**
 * Configuration
 */
class Config {
    /**
     * Information keys
     */
    const INFO_OS = "OS";
    const INFO_PHP = "PHP";
    const INFO_API = "API";
    const INFO_SDK = "SDK";

    /**
     * Blockchain networks
     */
    const NETWORK_MAINNET = "MainNet";
    const NETWORK_TESTNET = "TestNet";

    /**
     * Current network
     *
     * @var string
     */
    protected $_network = self::NETWORK_TESTNET;

    /**
     * API Key
     *
     * @var string
     */
    protected $_apiKey = "";

    /**
     * The host
     *
     * @var string
     */
    protected $_host = 'https://api.tatum.io';

    /**
     * User agent of the HTTP request, set to "Tatum_SDK_PHP/2.0.0" by default
     * 
     * @var string
     */
    protected $_userAgent = "Tatum_SDK_PHP/2.0.0";

    /**
     * Debug switch (default set to false)
     *
     * @var bool
     */
    protected $_debug = false;

    /**
     * Debug file location (log to STDOUT by default)
     *
     * @var string
     */
    protected $_debugFile = "php://output";

    /**
     * Debug sanitization switch (default set to true)
     * 
     * @var bool
     */
    protected $_debugSanitize = true;

    /**
     * Debugger
     * 
     * @var \Tatum\Sdk\Debugger|null
     */
    protected $_debugger = null;

    /**
     * Debug file location (log to STDOUT by default)
     *
     * @var string
     */
    protected $_tempFolderPath;

    /**
     * Constructor
     *
     * @param string $apiKey    API Key
     * @param bool   $isMainNet MainNet configuration
     */
    public function __construct(string $apiKey, bool $isMainNet) {
        $this->setApiKey($apiKey);
        $this->_network = $isMainNet ? self::NETWORK_MAINNET : self::NETWORK_TESTNET;
        $this->setTempFolderPath(sys_get_temp_dir());
    }

    /**
     * Set the API key
     *
     * @param string $key API key or token
     *
     * @return $this
     */
    public function setApiKey(string $key) {
        $this->_apiKey = "$key";

        return $this;
    }

    /**
     * Get the API key
     *
     * @return string API key
     */
    public function getApiKey(): string {
        return $this->_apiKey;
    }

    /**
     * Are we using the MainNet?
     *
     * @return bool True for MainNet, false for TestNet
     */
    public function isMainNet(): bool {
        return self::NETWORK_MAINNET === $this->_network;
    }

    /**
     * Get the host
     *
     * @return string Host
     */
    public function getHost(): string {
        return $this->_host;
    }

    /**
     * Set the host
     *
     * @param string $host Host
     * @return $this
     */
    public function setHost(string $host) {
        $this->_host = trim($host);

        return $this;
    }

    /**
     * Get the User Agent
     *
     * @return string User agent
     */
    public function getUserAgent(): string {
        return $this->_userAgent;
    }

    /**
     * Set the debug flag
     *
     * @param bool $debug Debug flag
     * @return $this
     */
    public function setDebug(bool $debug) {
        $this->_debug = $debug;

        return $this;
    }

    /**
     * Get the debug flag
     *
     * @return bool
     */
    public function getDebug(): bool {
        return $this->_debug;
    }

    /**
     * Set the debug file
     *
     * @param string $debugFile Debug file
     * @return $this
     */
    public function setDebugFile(string $debugFile) {
        $this->_debugFile = $debugFile;

        return $this;
    }

    /**
     * Get the debug file
     *
     * @return string
     */
    public function getDebugFile(): string {
        return $this->_debugFile;
    }

    /**
     * Switch debug sanitizer on or off
     * 
     * @param bool $sanitize
     * @return $this
     */
    public function setDebugSanitizer(bool $sanitize) {
        $this->_debugSanitize = !!$sanitize;

        return $this;
    }

    /**
     * Get whether the debug sanitizer is enabled
     * 
     * @return bool
     */
    public function getDebugSanitizer() {
        return $this->_debugSanitize;
    }

    /**
     * Fetch the debugger object
     * 
     * @return \Tatum\Sdk\Debugger
     */
    public function debugger(): Debugger {
        if (null === $this->_debugger) {
            $this->_debugger = new Debugger($this);
        }

        return $this->_debugger;
    }

    /**
     * Sets the temp folder path; creates the directory with chmod 0644
     * Used to store files downloaded with the API via \SplFileObject
     *
     * @param string $tempFolderPath Temp folder path
     *
     * @return $this
     */
    public function setTempFolderPath(string $tempFolderPath) {
        $this->_tempFolderPath = $tempFolderPath;

        // Create the path
        if (!is_dir($this->_tempFolderPath)) {
            mkdir($this->_tempFolderPath, 0664, true);
        }

        return $this;
    }

    /**
     * Gets the temp folder path; by default it's "{system temporary folder}"
     * Used to store files downloaded with the API via \SplFileObject
     *
     * @return string Temp folder path
     */
    public function getTempFolderPath(): string {
        return $this->_tempFolderPath;
    }

    /**
     * Get the essential system information for debugging
     *
     * @return array
     */
    public function getVersions(): array {
        return [
            self::INFO_OS  => php_uname(),
            self::INFO_PHP => PHP_VERSION,
            self::INFO_API => "3.17.2",
            self::INFO_SDK => "2.0.0",
        ];
    }
}
