<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\AssetScrapingRequest;
use App\Models\AssetScraping;
use App\Models\CryptoTradingProfitTransaction;
use App\Models\VirtualAccounts;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class AssetScrapingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $assetScrapings = AssetScraping::paginate();

        return view('asset-scraping.index', compact('assetScrapings'))
            ->with('i', ($request->input('page', 1) - 1) * $assetScrapings->perPage());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function profitScraping(): View
    {
        $assetScraping = new AssetScraping();
        $transactions = CryptoTradingProfitTransaction::where('account_type','Profit')->where('transaction_type','Credit')->where('withdraw_status',0)->get();
$account =  VirtualAccounts::where('blockchain_code',"USDT_TRON")->where('virtual_account_type','Profit')->firstOrFail();
        return view('admin.asset-scraping.create', compact('assetScraping','transactions', 'account'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function processProfitScraping(AssetScrapingRequest $request): RedirectResponse
    {
        $transactions = CryptoTradingProfitTransaction::where('account_type','Profit')->where('transaction_type','Credit')->where('withdraw_status',0)->get();
        $account =  VirtualAccounts::where('blockchain_code',"USDT_TRON")->where('virtual_account_type','Profit')->firstOrFail();
        AssetScraping::create($request->validated());

        return Redirect::route('asset-scrapings.index')
            ->with('success', 'AssetScraping created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show($id): View
    {
        $assetScraping = AssetScraping::find($id);

        return view('asset-scraping.show', compact('assetScraping'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id): View
    {
        $assetScraping = AssetScraping::find($id);

        return view('asset-scraping.edit', compact('assetScraping'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(AssetScrapingRequest $request, AssetScraping $assetScraping): RedirectResponse
    {
        $assetScraping->update($request->validated());

        return Redirect::route('asset-scrapings.index')
            ->with('success', 'AssetScraping updated successfully');
    }

    public function destroy($id): RedirectResponse
    {
        AssetScraping::find($id)->delete();

        return Redirect::route('asset-scrapings.index')
            ->with('success', 'AssetScraping deleted successfully');
    }
}
