<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\CardMaintenanceChargeRequest;
use App\Models\CardMaintenanceCharge;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class CardMaintenanceChargeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $cardMaintenanceCharges = CardMaintenanceCharge::paginate();

        return view('admin.card-maintenance-charge.index', compact('cardMaintenanceCharges'))
            ->with('i', ($request->input('page', 1) - 1) * $cardMaintenanceCharges->perPage());
    }



    /**
     * Display the specified resource.
     */
    public function show($id): View
    {
        $cardMaintenanceCharge = CardMaintenanceCharge::find($id);

        return view('card-maintenance-charge.show', compact('cardMaintenanceCharge'));
    }


}
