<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\CryptoTradingProfitTransactionRequest;
use App\Models\CryptoTradingProfitTransaction;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class CryptoTradingProfitTransactionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function allTransaction(Request $request): View
    {
        $cryptoTradingProfitTransactions = CryptoTradingProfitTransaction::paginate();

        return view('admin.crypto-trading-profit-transaction.index', compact('cryptoTradingProfitTransactions'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTradingProfitTransactions->perPage());
    }
    public function profitTransactions(Request $request): View
    {
        $cryptoTradingProfitTransactions = CryptoTradingProfitTransaction::where('transaction_type','Profit')->paginate();
$pageTitle='Profit On Withdraw List';
        return view('admin.crypto-trading-profit-transaction.index', compact('cryptoTradingProfitTransactions','pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTradingProfitTransactions->perPage());
    }
    public function tradeTransactions(Request $request): View
    {
        $cryptoTradingProfitTransactions = CryptoTradingProfitTransaction::where('transaction_type','Trading')->paginate();
        $pageTitle='Trading Transaction List';
        return view('admin.crypto-trading-profit-transaction.index', compact('cryptoTradingProfitTransactions','pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTradingProfitTransactions->perPage());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function collectAsset(): View
    {
        $cryptoTradingProfitTransaction = new CryptoTradingProfitTransaction();

        return view('crypto-trading-profit-transaction.create', compact('cryptoTradingProfitTransaction'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function storeCollectedAsset(CryptoTradingProfitTransactionRequest $request): RedirectResponse
    {
        CryptoTradingProfitTransaction::create($request->validated());

        return Redirect::route('crypto-trading-profit-transactions.index')
            ->with('success', 'CryptoTradingProfitTransaction created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show($id): View
    {
        $cryptoTradingProfitTransaction = CryptoTradingProfitTransaction::find($id);

        return view('crypto-trading-profit-transaction.show', compact('cryptoTradingProfitTransaction'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id): View
    {
        $cryptoTradingProfitTransaction = CryptoTradingProfitTransaction::find($id);

        return view('crypto-trading-profit-transaction.edit', compact('cryptoTradingProfitTransaction'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(CryptoTradingProfitTransactionRequest $request, CryptoTradingProfitTransaction $cryptoTradingProfitTransaction): RedirectResponse
    {
        $cryptoTradingProfitTransaction->update($request->validated());

        return Redirect::route('crypto-trading-profit-transactions.index')
            ->with('success', 'CryptoTradingProfitTransaction updated successfully');
    }

    public function destroy($id): RedirectResponse
    {
        CryptoTradingProfitTransaction::find($id)->delete();

        return Redirect::route('crypto-trading-profit-transactions.index')
            ->with('success', 'CryptoTradingProfitTransaction deleted successfully');
    }
}
