<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\CryptoTransactionRequest;
use App\Models\CryptoTransaction;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class CryptoTransactionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function allWithdraw(Request $request): View
    {
        $cryptoTransactions = CryptoTransaction::where('transaction_type',2)->paginate();
$pageTitle = 'All Crypto Withdraw';
        return view('admin.crypto-transaction.index', compact('cryptoTransactions', 'pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTransactions->perPage());
    }
 public function pendingWithdraw(Request $request): View
    {
        $cryptoTransactions = CryptoTransaction::where('transaction_type',2)->where('payment_status','Pending')->paginate();

        $pageTitle = 'Pending Crypto Withdraw';
        return view('admin.crypto-transaction.index', compact('cryptoTransactions', 'pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTransactions->perPage());
    }
    public function successfulWithdraw(Request $request): View
    {
        $cryptoTransactions = CryptoTransaction::where('transaction_type',2)->where('payment_status','Completed')->paginate();

        $pageTitle = 'Pending Crypto Withdraw';
        return view('admin.crypto-transaction.index', compact('cryptoTransactions', 'pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTransactions->perPage());
    }
    public function failedWithdraw(Request $request): View
    {
        $cryptoTransactions = CryptoTransaction::where('transaction_type',2)->where('payment_status','failed')->paginate();
        $pageTitle = 'Failed Crypto Withdraw';
        return view('admin.crypto-transaction.index', compact('cryptoTransactions', 'pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTransactions->perPage());
    }
  public function allBuyingRequest(Request $request): View
    {
        $cryptoTransactions = CryptoTransaction::where('transaction_type',1)->paginate();
        $pageTitle = 'All Crypto Buying Transaction';
        return view('admin.crypto-transaction.index', compact('cryptoTransactions', 'pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTransactions->perPage());
    }
    public function pendingBuyingRequest(Request $request): View
    {
        $cryptoTransactions = CryptoTransaction::where('transaction_type',1)->where('payment_status','Pending')->paginate();
        $pageTitle = 'Pending Crypto Buying Transaction';
        return view('admin.crypto-transaction.index', compact('cryptoTransactions', 'pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTransactions->perPage());
    }
 public function successfulBuyingRequest(Request $request): View
    {
        $cryptoTransactions = CryptoTransaction::where('transaction_type',1)->where('payment_status','Completed')->paginate();

        $pageTitle = 'Successful Buying Crypto Transaction ';
        return view('admin.crypto-transaction.index', compact('cryptoTransactions', 'pageTitle'))
            ->with('i', ($request->input('page', 1) - 1) * $cryptoTransactions->perPage());
    }


    public function tradeScraping(){

    }


}
