<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\MediaHelper;
use App\Http\Controllers\Controller;
use App\Models\Products;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ProductsController extends Controller
{
    //
    public function index(){
$products = Products::paginate(15);
    return view('admin.products.index', compact('products'));
    }


    public function addProduct(){
        return view('admin.products.create');
    }
    public function editProduct(Request $request){

        $model = Products::where('slug',$request->id)->firstOrFail();

        return view('admin.products.edit', compact('model'));
    }

    public function saveProduct(Request $request){
      //  dd($request);
    $request->validate(
        [
           'product_name'=>'required',
           'product_description'=>'required',
           'currency'=>'required',
           'price'=>'required',
           'status'=>'required',
            'product_image1'=>'required'
        ]
    );
        $product = new Products();

    if($request->hasFile('product_image1')){
        $product_image1 = $request->file('product_image1');
       // $p_image1_name = Str::uuid() . "." . $product_image1->extension();
      //  $product_image1->storeAs('products', $p_image1_name, config('chatify.storage_disk_name'));
        $product->p_image1  = MediaHelper::handleMakeImage($product_image1,'products');
    }
if($request->hasFile('product_image2')){
        $product_image2 = $request->file('product_image2');
       // $p_image2_name = Str::uuid() . "." . $product_image2->extension();
       // $product_image2->storeAs('products', $p_image2_name, config('chatify.storage_disk_name'));
   // $product->p_image2 = $p_image2_name;
   // $product->p_image2 = $p_image2_name;
    $product->p_image2  = MediaHelper::handleMakeImage($product_image2,'products');
    }
if($request->hasFile('product_image3')){
    $product_image3 = $request->file('product_image3');
       /* $product_image3 = $request->file('product_image3');
        $p_image3_name = Str::uuid() . "." . $product_image3->extension();
        $product_image3->storeAs('products', $p_image3_name, config('chatify.storage_disk_name'));
    $product->p_image3 = $p_image3_name;
       */
    $product->p_image3  = MediaHelper::handleMakeImage($product_image3,'products');

    }
if($request->hasFile('product_image4')){
    $product_image4 = $request->file('product_image4');
    /*    $product_image4 = $request->file('product_image4');
        $p_image4_name = Str::uuid() . "." . $product_image4->extension();
        $product_image4->storeAs('products', $p_image4_name, config('chatify.storage_disk_name'));
    $product->p_image4 = $p_image4_name;
    */
    $product->p_image4  = MediaHelper::handleMakeImage($product_image4,'products');

}
        $slug = Str::slug($request->product_name);
  //  dd($request);
        while(Products::where('slug', $slug)->exists()) {
            $slug = Str::slug($request->product_name) . '-' . $count;
            $count++;
        }

        $product->slug =$slug;
    $product->product_name = $request->product_name;
    $product->product_description = $request->product_description;
    $product->status = $request->status;
    $product->price = $request->price;
    $product->currency = $request->currency;
    $product->save();
        return back()->with('success','Product Added Successfully');

    }
  public function saveEditProduct(Request $request){
      //  dd($request);
    $request->validate(
        [
           'product_name'=>'required',
           'product_description'=>'required',
           'currency'=>'required',
           'price'=>'required',
           'status'=>'required',
            //'product_image1'=>'required'
        ]
    );
        $product =  Products::where('slug',$request->id)->firstOrFail();
       // dd($request);

      if($request->hasFile('product_image1')){
          $product_image1 = $request->file('product_image1');
          // $p_image1_name = Str::uuid() . "." . $product_image1->extension();
          //  $product_image1->storeAs('products', $p_image1_name, config('chatify.storage_disk_name'));
          $product->p_image1  = MediaHelper::handleMakeImage($product_image1,'products');
      }
      if($request->hasFile('product_image2')){
          $product_image2 = $request->file('product_image2');
          // $p_image2_name = Str::uuid() . "." . $product_image2->extension();
          // $product_image2->storeAs('products', $p_image2_name, config('chatify.storage_disk_name'));
          // $product->p_image2 = $p_image2_name;
          // $product->p_image2 = $p_image2_name;
          $product->p_image2  = MediaHelper::handleMakeImage($product_image2,'products');
      }
      if($request->hasFile('product_image3')){
          $product_image3 = $request->file('product_image3');
          /* $product_image3 = $request->file('product_image3');
           $p_image3_name = Str::uuid() . "." . $product_image3->extension();
           $product_image3->storeAs('products', $p_image3_name, config('chatify.storage_disk_name'));
       $product->p_image3 = $p_image3_name;
          */
          $product->p_image3  = MediaHelper::handleMakeImage($product_image3,'products');

      }
      if($request->hasFile('product_image4')){
          $product_image4 = $request->file('product_image4');
          /*    $product_image4 = $request->file('product_image4');
              $p_image4_name = Str::uuid() . "." . $product_image4->extension();
              $product_image4->storeAs('products', $p_image4_name, config('chatify.storage_disk_name'));
          $product->p_image4 = $p_image4_name;
          */
          $product->p_image4  = MediaHelper::handleMakeImage($product_image4,'products');

      }
       if($product->product_name!=trim($request->product_name)) { //this mean their is changes in product name
           $slug = Str::slug($request->product_name);
           //  dd($request);
           while (Products::where('slug', $slug)->exists()) {
               $slug = Str::slug($request->product_name) . '-' . $count;
               $count++;
           }

           $product->slug = $slug;
           $product->product_name = $request->product_name;
       }
    $product->product_description = $request->product_description;
    $product->status = $request->status;
    $product->price = str_replace(",", "", $request->price);
    $product->currency = $request->currency;
    $product->save();
        return back()->with('success','Product Updated Successfully');

    }


}
