<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\VirtualcardCustomerRequest;
use App\Models\TransactionHistory;
use App\Models\VirtualcardCustomer;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class VirtualcardCustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $virtualcardCustomers = VirtualcardCustomer::paginate();

        return view('virtualcard-customer.index', compact('virtualcardCustomers'))
            ->with('i', ($request->input('page', 1) - 1) * $virtualcardCustomers->perPage());
    }
    public function requestList(Request $request): View
    {
        $requestList = TransactionHistory::where('transaction_type','Card Issuance')->paginate();

        return view('virtualcard-customer.request_list', compact('requestList'))
            ->with('i', ($request->input('page', 1) - 1) * $requestList->perPage());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(): View
    {
        $virtualcardCustomer = new VirtualcardCustomer();

        return view('virtualcard-customer.create', compact('virtualcardCustomer'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(VirtualcardCustomerRequest $request): RedirectResponse
    {
        $validated = $request->validated();

        VirtualcardCustomer::create($request->validated());

        return Redirect::route('virtualcard-customers.index')
            ->with('success', 'VirtualcardCustomer created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show($id): View
    {
        $virtualcardCustomer = VirtualcardCustomer::find($id);

        return view('virtualcard-customer.show', compact('virtualcardCustomer'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id): View
    {
        $virtualcardCustomer = VirtualcardCustomer::find($id);

        return view('virtualcard-customer.edit', compact('virtualcardCustomer'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(VirtualcardCustomerRequest $request, VirtualcardCustomer $virtualcardCustomer): RedirectResponse
    {
        $virtualcardCustomer->update($request->validated());

        return Redirect::route('virtualcard-customers.index')
            ->with('success', 'VirtualcardCustomer updated successfully');
    }

    public function destroy($id): RedirectResponse
    {
        VirtualcardCustomer::find($id)->delete();

        return Redirect::route('virtualcard-customers.index')
            ->with('success', 'VirtualcardCustomer deleted successfully');
    }

public function repushNotification(Request $request){
    // Retrieve the transaction reference from the request
    $txRef = $request->input('txRef');

    // Perform your logic here, such as requerying the request or handling the transaction
    // Example:
    $virtualCard = TransactionHistory::select('transaction_ref')->where('transaction_ref', $txRef)->first();

    if ($virtualCard) {
       repushBolddNotification($virtualCard->transaction_ref);
    }
    return back()
        ->with('success', 'Operation Successful');
}
}
