<?php

namespace App\Http\Controllers;

use App\Models\AssetScrapedList;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\AssetScrapedListRequest;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class AssetScrapedListController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $assetScrapedLists = AssetScrapedList::paginate();

        return view('asset-scraped-list.index', compact('assetScrapedLists'))
            ->with('i', ($request->input('page', 1) - 1) * $assetScrapedLists->perPage());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(): View
    {
        $assetScrapedList = new AssetScrapedList();

        return view('asset-scraped-list.create', compact('assetScrapedList'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(AssetScrapedListRequest $request): RedirectResponse
    {
        AssetScrapedList::create($request->validated());

        return Redirect::route('asset-scraped-lists.index')
            ->with('success', 'AssetScrapedList created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show($id): View
    {
        $assetScrapedList = AssetScrapedList::find($id);

        return view('asset-scraped-list.show', compact('assetScrapedList'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id): View
    {
        $assetScrapedList = AssetScrapedList::find($id);

        return view('asset-scraped-list.edit', compact('assetScrapedList'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(AssetScrapedListRequest $request, AssetScrapedList $assetScrapedList): RedirectResponse
    {
        $assetScrapedList->update($request->validated());

        return Redirect::route('asset-scraped-lists.index')
            ->with('success', 'AssetScrapedList updated successfully');
    }

    public function destroy($id): RedirectResponse
    {
        AssetScrapedList::find($id)->delete();

        return Redirect::route('asset-scraped-lists.index')
            ->with('success', 'AssetScrapedList deleted successfully');
    }
}
