<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Pusher\Pusher;

class PusherAuthController extends Controller
{
    public $pusher;
    public function __construct()
    {
        $this->pusher = new Pusher(
            config('chatify.pusher.key'),
            config('chatify.pusher.secret'),
            config('chatify.pusher.app_id'),
            config('chatify.pusher.options'),
        );
    }
    //
    public function merchantAuth(Request $request){
        // Log::info($request);
        $requestUser= $request->user();
        Log::info($requestUser);
        $authUser= Auth::user();
        // Log::info(  $request['channel_name']);
        $channelName=$request['channel_name'];
        $socket_id=  $request['socket_id'];
        // return response()->json(['message'=>'Not authenticated'], 403);
        if (Auth::check()) {
            Log::info(  $request['channel_name']);
            if ($channelName == "presence-activeStatus") {
                // Auth data
                Log::info(  $request['channel_name']);
                $authData = json_encode([
                    'user_id' => $authUser->access_key,
                    'user_info' => [
                        'name' => $authUser->name,
                        'userType' => 'M'
                    ]
                ]);
                // check if user authenticated

                if ($requestUser->access_key == $authUser->access_key) {

                    return $this->pusher->socket_auth(
                        $channelName,
                        $socket_id,
                        $authData
                    );
                }
                // Log::info("notauthorie");
                // Log::info($authUser->id);
                // if not authorized
                return response()->json(['message' => 'Unauthorized'], 401);

            }elseif($channelName=='private-notify.') {
            return response()->json(['message' => 'Unauthorized - Unknown Client'], 401);
        }elseif (str_contains($channelName, 'private-notify.')){
            // check if user authenticated

            if ($requestUser->access_key == $authUser->access_key) {

                return $this->pusher->socket_auth(
                    $channelName,
                    $socket_id

                );
            }
            Log::info("notauthorie");
            // Log::info($authUser->id);
            // if not authorized
            return response()->json(['message' => 'Unauthorized'], 401);

        }  else {
                // check if user authenticated

                if ($requestUser->access_key == $authUser->access_key) {

                    return $this->pusher->socket_auth(
                        $channelName,
                        $socket_id

                    );
                }
                 Log::info("notauthorie");
                // Log::info($authUser->id);
                // if not authorized
                return response()->json(['message' => 'Unauthorized'], 401);

            }
        }
            // if not authenticated
            return response()->json(['message' => 'Not authenticated'], 403);

        }
    public function userAuth(Request $request){


        // Log::info($request);
        $requestUser= $request->user();
        //Log::info($requestUser);
        $authUser= Auth::user();
       // Log::info(  $request['channel_name']);
        $channelName=$request['channel_name'];
        $socket_id=  $request['socket_id'];
       // return response()->json(['message'=>'Not authenticated'], 403);
        if (Auth::check()) {
            if ($channelName == "presence-activeStatus") {
                // Auth data
                $authData = json_encode([
                    'user_id' => $authUser->id,
                    'user_info' => [
                        'name' => $authUser->name,
                        'userType' => 'U'
                    ]
                ]);
                // check if user authenticated

                if ($requestUser->id == $authUser->id) {

                    return $this->pusher->socket_auth(
                        $channelName,
                        $socket_id,
                        $authData
                    );
                }
                // Log::info("notauthorie");
                // Log::info($authUser->id);
                // if not authorized
                return response()->json(['message' => 'Unauthorized'], 401);

            }elseif($channelName=='private-notify.') {
                return response()->json(['message' => 'Unauthorized - Unknown Client'], 401);
            }elseif (str_contains($channelName, 'private-notify.')){
            // check if user authenticated

            if ($requestUser->access_key == $authUser->access_key) {

                return $this->pusher->socket_auth(
                    $channelName,
                    $socket_id

                );
            }
            Log::info("notauthorie");
            // Log::info($authUser->id);
            // if not authorized
            return response()->json(['message' => 'Unauthorized'], 401);

        }  else {
                // check if user authenticated

                if ($requestUser->id == $authUser->id) {

                    return $this->pusher->socket_auth(
                        $channelName,
                        $socket_id

                    );
                }
                // Log::info("notauthorie");
                // Log::info($authUser->id);
                // if not authorized
                return response()->json(['message' => 'Unauthorized'], 401);

            }
        }
            // if not authenticated
            return response()->json(['message'=>'Not authenticated'], 403);

    }



}
