<?php

namespace App\Http\Controllers;

use App\Models\TransactionHistory;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\TransactionHistoryRequest;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class TransactionHistoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $transactionHistories = TransactionHistory::paginate();

        return view('transaction-history.index', compact('transactionHistories'))
            ->with('i', ($request->input('page', 1) - 1) * $transactionHistories->perPage());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(): View
    {
        $transactionHistory = new TransactionHistory();

        return view('transaction-history.create', compact('transactionHistory'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(TransactionHistoryRequest $request): RedirectResponse
    {
        TransactionHistory::create($request->validated());

        return Redirect::route('transaction-histories.index')
            ->with('success', 'TransactionHistory created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show($id): View
    {
        $transactionHistory = TransactionHistory::find($id);

        return view('transaction-history.show', compact('transactionHistory'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id): View
    {
        $transactionHistory = TransactionHistory::find($id);

        return view('transaction-history.edit', compact('transactionHistory'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(TransactionHistoryRequest $request, TransactionHistory $transactionHistory): RedirectResponse
    {
        $transactionHistory->update($request->validated());

        return Redirect::route('transaction-histories.index')
            ->with('success', 'TransactionHistory updated successfully');
    }

    public function destroy($id): RedirectResponse
    {
        TransactionHistory::find($id)->delete();

        return Redirect::route('transaction-histories.index')
            ->with('success', 'TransactionHistory deleted successfully');
    }
}
