<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Products;
use Illuminate\Http\Request;

class ShoppingController extends Controller
{
    //
    public function index(){
        $search = request('q');
        $products = Products::where('status',1)->when($search, function($q) use($search){$q->where('product_name','like',"%$search%")->orWhere('product_description','like',"%$search%");})->get();
        return view('user.shopping.index', compact('products'));
    }

    public function productDetails(Request $request){
        $product = Products::where('slug',$request->slug)->firstorFail();
        return view('user.shopping.product_details',compact('product'));
    }

}
