<?php

namespace App\Http\Controllers;

use App\Models\VirtualCard;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\VirtualCardRequest;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class VirtualCardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $virtualCards = VirtualCard::paginate();

        return view('virtual-card.index', compact('virtualCards'))
            ->with('i', ($request->input('page', 1) - 1) * $virtualCards->perPage());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(): View
    {
        $virtualCard = new VirtualCard();

        return view('virtual-card.create', compact('virtualCard'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(VirtualCardRequest $request): RedirectResponse
    {
        VirtualCard::create($request->validated());

        return Redirect::route('virtual-cards.index')
            ->with('success', 'VirtualCard created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show($id): View
    {
        $virtualCard = VirtualCard::find($id);

        return view('virtual-card.show', compact('virtualCard'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id): View
    {
        $virtualCard = VirtualCard::find($id);

        return view('virtual-card.edit', compact('virtualCard'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(VirtualCardRequest $request, VirtualCard $virtualCard): RedirectResponse
    {
        $virtualCard->update($request->validated());

        return Redirect::route('virtual-cards.index')
            ->with('success', 'VirtualCard updated successfully');
    }

    public function destroy($id): RedirectResponse
    {
        VirtualCard::find($id)->delete();

        return Redirect::route('virtual-cards.index')
            ->with('success', 'VirtualCard deleted successfully');
    }
}
