<?php

namespace App\Http\Controllers;

use App\Models\VirtualCardsSetting;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Http\Requests\VirtualCardsSettingRequest;
use Illuminate\Support\Facades\Redirect;
use Illuminate\View\View;

class VirtualCardsSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $virtualCardsSettings = VirtualCardsSetting::paginate();

        return view('virtual-cards-setting.index', compact('virtualCardsSettings'))
            ->with('i', ($request->input('page', 1) - 1) * $virtualCardsSettings->perPage());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(): View
    {
        $virtualCardsSetting = new VirtualCardsSetting();

        return view('virtual-cards-setting.create', compact('virtualCardsSetting'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(VirtualCardsSettingRequest $request): RedirectResponse
    {
        VirtualCardsSetting::create($request->validated());

        return Redirect::route('admin.virtual-cards-settings.index')
            ->with('success', 'VirtualCardsSetting created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show($id): View
    {
        $virtualCardsSetting = VirtualCardsSetting::find($id);

        return view('virtual-cards-setting.show', compact('virtualCardsSetting'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id): View
    {
        $virtualCardsSetting = VirtualCardsSetting::find($id);

        return view('virtual-cards-setting.edit', compact('virtualCardsSetting'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(VirtualCardsSettingRequest $request,$id): RedirectResponse
    {
        $virtualCardsSetting = VirtualCardsSetting::find($id);
        $virtualCardsSetting->update($request->validated());

        return Redirect::route('admin.virtual-cards-settings.index')
            ->with('success', 'VirtualCardsSetting updated successfully');
    }

    public function destroy($id): RedirectResponse
    {
        VirtualCardsSetting::find($id)->delete();

        return Redirect::route('virtual-cards-settings.index')
            ->with('success', 'VirtualCardsSetting deleted successfully');
    }
}
