<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AssetScrapedListRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
			'virtual_account_id' => 'required|string',
			'sending_address' => 'required|string',
			'receiving_address' => 'required|string',
			'amount' => 'required',
			'blockchain_trx_id' => 'string',
			'remarks' => 'string',
			'transaction_type' => 'required|string',
			'_id' => 'string',
			'created_ip' => 'string',
			'created_by' => 'string',
			'updated_by' => 'string',
			'created_agent' => 'string',
			'updated_agent' => 'string',
			'updated_ip' => 'string',
        ];
    }
}
