<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AssetScrapingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
			'batch_id' => 'required|string',
			'total_asset_scrap_success' => 'required',
			'total_asset_scrap_failed' => 'required',
			'receiving_address' => 'required|string',
			'transaction_type' => 'required|string',
			'coin' => 'required',
			'total_count_successful' => 'required',
			'total_count_failed' => 'required',
			'_id' => 'string',
			'created_ip' => 'string',
			'created_by' => 'string',
			'updated_by' => 'string',
			'created_agent' => 'string',
			'updated_agent' => 'string',
			'updated_ip' => 'string',
        ];
    }
}
