<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CardMaintenanceChargeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
			'batch_id' => 'required|string',
			'total_deducted_amount' => 'required',
			'total_count_in_credit' => 'required',
			'total_count_in_paid' => 'required',
			'maintenance_fees' => 'required',
			'exchange_rate' => 'required',
			'deduction_month' => 'required|string',
			'deduction_year' => 'required|string',
			'_id' => 'string',
			'created_ip' => 'string',
			'created_by' => 'string',
			'updated_by' => 'string',
			'created_agent' => 'string',
			'updated_agent' => 'string',
			'updated_ip' => 'string',
        ];
    }
}
