<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CryptoTradingProfitTransactionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
			'user_id' => 'required',
			'wallet_address' => 'required|string',
			'virtual_account_id' => 'required|string',
			'blockchain_code' => 'string',
			'amount' => 'required',
			'trading_ref' => 'string',
			'descriptions' => 'string',
			'withdraw_amount' => 'required',
			'withdraw_status' => 'required',
        ];
    }
}
