<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CryptoTransactionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
			'price_amount' => 'string',
			'price_currency' => 'string',
			'order_id' => 'required|string',
			'pay_currency' => 'string',
			'payout_currency' => 'string',
			'sender_address' => 'string',
			'transfer_type' => 'required|string',
			'send_from' => 'required|string',
			'send_to' => 'required|string',
			'payment_id' => 'string',
			'payment_status' => 'string',
			'pay_amount' => 'string',
			'amount_received' => 'string',
			'order_description' => 'string',
			'payin_extra_id' => 'string',
			'ipn_callback_url' => 'string',
			'server_created_at' => 'string',
			'server_updated_at' => 'string',
			'purchase_id' => 'string',
			'network' => 'string',
			'expiration_estimate_date' => 'string',
			'is_fixed_rate' => 'string',
			'is_fee_paid_by_user' => 'string',
			'valid_until' => 'string',
			'type' => 'string',
			'payment_creation_status' => 'string',
			'user_id' => 'required',
			'rate' => 'string',
			'converted_amount' => 'string',
			'fund_wallet_status' => 'string',
			'fund_wallet_status_at' => 'string',
			'approved_wallet_funding_method' => 'string',
			'approved_wallet_funding_at' => 'string',
			'approved_wallet_funding_by' => 'string',
			'recieved_converted_amount' => 'string',
			'price_in_usd' => 'string',
			'outcome_amount' => 'string',
			'outcome_currency' => 'string',
			'actually_paid' => 'string',
			'coin_confirm_status' => 'string',
			'txid' => 'string',
			'vin_crypto' => 'string',
			'vout_crypto' => 'string',
			'txt_fees' => 'string',
			'vin_amount_usd' => 'string',
			'vout_amount_usd' => 'string',
			'refer_bonus' => 'string',
			'payment_method' => 'string',
			'coin_rate' => 'string',
			'coin' => 'string',
			'blockchain_code' => 'string',
			'transaction_reference' => 'string',
			'deducted_account' => 'string',
			'deducted_asset_amount' => 'string',
			'deducted_asset_amount_usd' => 'string',
			'master_address' => 'string',
			'token_address' => 'string',
			'recipient_address' => 'string',
			'gas_fees' => 'string',
			'profit_on_gas' => 'string',
			'payment_reference' => 'string',
			'coin_amount' => 'string',
        ];
    }
}
