<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TransactionHistoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
			'descriptions' => 'required|string',
			'trade_id' => 'required',
			'request_id' => 'required|string',
			'tradedcard_details_id' => 'required',
			'transaction_ref' => 'required|string',
			'amount' => 'required',
			'transaction_amount_in_usd' => 'string',
			'exchange_rate' => 'string',
			'user_id' => 'required',
			'transaction_type' => 'required|string',
			'created_by' => 'required',
			'source' => 'required|string',
			'status' => 'required|string',
			'status_reason' => 'string',
			'currency' => 'string',
        ];
    }
}
