<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VirtualcardCustomerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
			'user_id' => 'required',
			'first_name' => 'required|string',
			'last_name' => 'required|string',
			'phone_number' => 'required|string',
			'bvnno' => 'required|string',
			'email_address' => 'required|string',
			'house_no' => 'required|string',
			'street' => 'required|string',
			'city' => 'required|string',
			'state' => 'required|string',
			'country' => 'required|string',
			'postal_code' => 'required|string',
			'idtype' => 'required|string',
			'idno' => 'required|string',
			'idurl' => 'required|string',
			'issuance_country' => 'required|string',
        ];
    }
}
