<?php

namespace App\Models;

use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Admin extends Authenticatable
{
    use HasFactory,HasRoles;

     /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */

    protected $guard_name = 'admin';
    protected $fillable = [
        'name',
        'email',
        'email_verify_token',
        'phone',
        'status',
        'role_id',
        'photo'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        'password',
    ];
    public function saveToClientWallet($amount,$user, $type){

        $getWallet =Wallet::where('user_id', $user)->first();
        if($type=='Pending') {
            $walletBalance = $getWallet->pending_balance;
            $getWallet->pending_balance = $walletBalance + $amount;

        }elseif($type=='Balance'){
            $walletBalance = $getWallet->balance;
            $getWallet->balance = $walletBalance + $amount;
        }elseif($type=='ReferPending'){
            $walletBalance = $getWallet->pending_refer_bonus;
            $getWallet->pending_refer_bonus = $walletBalance + $amount;
        }elseif($type=='Refer'){
            $walletBalance = $getWallet->refer_bonus_balance;
            $getWallet->refer_bonus_balance = $walletBalance + $amount;
        }

        $getWallet->save();

    }

    public function saveToClientWalletCrypto($amount,$user, $type){
        $getWallet =Wallet::where('user_id', $user)->first();
        if($type=='Pending') {
            $walletBalance = $getWallet->pending_balance;
            $getWallet->pending_balance = $walletBalance + $amount;
        }elseif($type=='Balance'){
            $walletBalance = $getWallet->balance;
            $getWallet->balance = $walletBalance + $amount;
        }elseif($type=='ReferPending'){
            $walletBalance = $getWallet->pending_refer_bonus;
            $getWallet->pending_refer_bonus = $walletBalance + $amount;
        }elseif($type=='Refer'){
            $walletBalance = $getWallet->refer_bonus_balance;
            $getWallet->refer_bonus_balance = $walletBalance + $amount;
        }
        $getWallet->save();

    }

}
