<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class AssetScrapedList
 *
 * @property $id
 * @property $virtual_account_id
 * @property $user_id
 * @property $sending_address
 * @property $receiving_address
 * @property $amount
 * @property $blockchain_trx_id
 * @property $status
 * @property $remarks
 * @property $transaction_type
 * @property $_id
 * @property $created_ip
 * @property $created_by
 * @property $updated_by
 * @property $created_agent
 * @property $updated_agent
 * @property $updated_ip
 * @property $created_at
 * @property $updated_at
 *
 * @property User $user
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class AssetScrapedList extends Model
{
    
    protected $perPage = 20;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['virtual_account_id', 'user_id', 'sending_address', 'receiving_address', 'amount', 'blockchain_trx_id', 'status', 'remarks', 'transaction_type', '_id', 'created_ip', 'created_by', 'updated_by', 'created_agent', 'updated_agent', 'updated_ip'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id', 'id');
    }
    
}
