<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class AssetScraping
 *
 * @property $id
 * @property $batch_id
 * @property $total_asset_scrap_success
 * @property $total_asset_scrap_failed
 * @property $receiving_address
 * @property $transaction_type
 * @property $coin
 * @property $total_count_successful
 * @property $total_count_failed
 * @property $process_date
 * @property $_id
 * @property $created_ip
 * @property $created_by
 * @property $updated_by
 * @property $created_agent
 * @property $updated_agent
 * @property $updated_ip
 * @property $created_at
 * @property $updated_at
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class AssetScraping extends Model
{
    
    protected $perPage = 20;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['batch_id', 'total_asset_scrap_success', 'total_asset_scrap_failed', 'receiving_address', 'transaction_type', 'coin', 'total_count_successful', 'total_count_failed', 'process_date', '_id', 'created_ip', 'created_by', 'updated_by', 'created_agent', 'updated_agent', 'updated_ip'];


}
