<?php

namespace App\Models;

use App\Traits\TracksCreationInfo;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CardMaintenanceCharge
 *
 * @property $id
 * @property $batch_id
 * @property $total_deducted_amount
 * @property $total_count_in_credit
 * @property $total_count_in_paid
 * @property $maintenance_fees
 * @property $exchange_rate
 * @property $billing_date
 * @property $deduction_month
 * @property $deduction_year
 * @property $_id
 * @property $created_ip
 * @property $created_by
 * @property $updated_by
 * @property $created_agent
 * @property $updated_agent
 * @property $updated_ip
 * @property $created_at
 * @property $updated_at
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class CardMaintenanceCharge extends Model
{

    use TracksCreationInfo;

    protected $perPage = 20;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['batch_id', 'total_deducted_amount', 'total_count_in_credit', 'total_count_in_paid', 'maintenance_fees', 'exchange_rate', 'billing_date', 'deduction_month', 'deduction_year', '_id', 'created_ip', 'created_by', 'updated_by', 'created_agent', 'updated_agent', 'updated_ip'];


}
